#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Delegator modul to start the install wizard. Later we can put a start menu here.
#

package SDB::Install::Gui::Frame::StartSetup;


use Wx qw (
    wxDefaultSize
    wxOK
    wxBLACK
    wxGROW
    wxRED
    wxEVT_COMMAND_ENTER
    wxICON_ERROR
    wxHORIZONTAL
    wxCENTRE
    wxICON_INFORMATION
    wxVERTICAL
    wxLI_HORIZONTAL 
    wxEXPAND
    );

use Wx::Event qw (EVT_SIZE EVT_COMMAND_ENTER EVT_SET_FOCUS);

#   Wizard structure
use SDB::Install::Gui::Window::Wizard;           
use SDB::Install::Gui::Window::SAPBanner;
#   Dialogs
#use SAPDB::Install::Wizard::PrototypeXT::UserHandling; # For later implementation of the privileged feature.
use SDB::Install::Gui::Dialogs::InstallUpdate;

#   Others
use SAPDB::Install::Frame::Base;
use SDB::Install::System;

our @ISA = qw (SAPDB::Install::Frame::Base);

our ($startWidth,$startHeight) = (800,700); # Wizard start width

#   Ask for Admin permission and takes initial setup.
sub new {
 	my( $class ) = shift;
    my( $this ) = $class->SUPER::new(@_);
    #
    #   Frame setup
    #
    $this->SetMinSize([$startWidth,$startHeight]);
    $this->SetSize([$startWidth,$startHeight]);
	$this;
}


#   Start the wizard. Build the UI Structure for the wizard and add steps to them.
sub StartWizard{
	my ($self) = @_;

    #
    #   Wizard
    #
	my $wizard = SDB::Install::Gui::Window::Wizard->new($self,-1,[-1,290],wxDefaultSize);
    #$self->Show (1);
    my $banner = SDB::Install::Gui::Window::SAPBanner->new($wizard,-1); # High is 83 because a little bit of the floorplan background belong to the banner
	$wizard->setBanner ($banner);

	my $app = Wx::wxTheApp ();

	my $kit = $app->{kit};

	if ($app->{kit}->IsDBStudioDistribution ()){
		require SDB::Install::Gui::Dialogs::SelectStudioInstallation;
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::SelectStudioInstallation ($wizard));
		require SDB::Install::Gui::Dialogs::SelectStudioFeatures;
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::SelectStudioFeatures ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Preparing ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Summary ($wizard));
		$wizard->AddDialog(new SDB::Install::Gui::Dialogs::Install ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Finalize ($wizard));
		
		$wizard->terminateChain ();
	}
	elsif ($app->{kit}->HasDBKernel ()){
    	$wizard->AddDialog (new SDB::Install::Gui::Dialogs::InstallUpdate ($wizard));
	}
	elsif ($app->{kit}->isClient ()){
		require SDB::Install::Gui::Dialogs::SelectInstallation;
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::SelectInstallation ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Preparing ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Summary ($wizard));
		$wizard->AddDialog(new SDB::Install::Gui::Dialogs::Install ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Finalize ($wizard));
		
		$wizard->terminateChain ();
	}
    elsif ($app->{kit}->isOfficeClient ()){
        require SDB::Install::Gui::Dialogs::SelectInstallation;
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::SelectInstallation ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Preparing ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Summary ($wizard));
		$wizard->AddDialog(new SDB::Install::Gui::Dialogs::Install ($wizard));
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Finalize ($wizard));

        $wizard->terminateChain ();
    }
    elsif ($app->{kit}->isServerPlugin ()){
        require SDB::Install::Gui::Dialogs::GenericParameter;
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::GenericParameter ($wizard));
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::Preparing ($wizard));
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::Summary ($wizard));
        $wizard->AddDialog(new SDB::Install::Gui::Dialogs::Install ($wizard));
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::Finalize ($wizard));

        $wizard->terminateChain ();
    }
    else{

        #
        # generic installation detected
        #
		require SDB::Install::Gui::Dialogs::SelectInstallation;
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::SelectInstallation ($wizard));
        require SDB::Install::Gui::Dialogs::GenericParameter;
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::GenericParameter ($wizard));
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::Preparing ($wizard));
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::Summary ($wizard));
        $wizard->AddDialog(new SDB::Install::Gui::Dialogs::Install ($wizard));
        $wizard->AddDialog (new SDB::Install::Gui::Dialogs::Finalize ($wizard));
        $wizard->terminateChain ();
    }


    #
    # change window title
    #
    my $productName = $kit->getProductName();
    my $productVersion = $kit->GetVersion();
    $app->GetTopWindow()->SetTitle($productName . ' Installation ' . $productVersion);

	$app->{kit}->SelectAllPackages ();
	$wizard->init;

    $self->{'wizard'} = $wizard;
    $self->Show (1);
    $wizard->SetDefaultFocus ();
}


#>---------------------------------Seek&Destroy Stuff------------------------------------------<#

sub Destroy{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #

    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #

    foreach my $element (
                        'wizard',
                       ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}


sub DESTROY{
	my ($self) = @_;
	print ">>>>>> DESTROYING $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;

1;
