package SDB::Install::Java;


use Cwd qw(realpath);
use SDB::Install::BaseLegacy;

use SDB::Install::System qw (which exec_program);
use SDB::Install::SysVars;

our @ISA = qw (SDB::Install::BaseLegacy);

use strict;

our @javas;


sub _resolveLinks{
	my ($link) = @_;
	my $tmp;
	while (-l $link){
		$tmp = readlink ($link);
		if ($tmp !~ /^\//){
			$link =~ s/\/[^\/]+\/{0,1}$//;
			$link = $link . '/' . $tmp;
		}
		else{
			$link = $tmp;
		}
	}
 	return $link;
}


sub GetJavas{
	my ($self,$nocache) = @_;
	my %stats;
	if (@javas && !$nocache){
		return \@javas;
	}
	my $java_home = exists $ENV{'JAVA_HOME'} ? $ENV{'JAVA_HOME'} : undef;
	
	if (!$java_home && $isApple){
		my $jhtool = '/usr/libexec/java_home';
		if (-x $jhtool){
			my $msg = $self->AddMessage ("Looking for JAVA_HOME via '$jhtool'");
			my $cfg = {'out' => \$java_home};
			my $rc = exec_program ($jhtool,['2>/dev/null'], $cfg);
			if ($rc != 0){
				$self->AddWarning ("Error calling $jhtool");
				undef $java_home;
			}
			$self->AddSubMsgLst ($msg,$cfg);
		}
	}

    if (defined $java_home && ($java_home =~ /^["'].*["']$/)){
        ($java_home) = ($java_home =~ /^["']+([^"']+)["']+$/);
    }

	my $test_java;
	my $tmp;
	my $i = 0;
	my @stat;
	my $v;
	if (defined $java_home){
		$test_java = join ($path_separator, $java_home, 'bin', ($isWin ? 'javaw.exe' : 'java'));
		if (-f $test_java){
			@stat = stat (_);
			$v = _get_java_version($test_java);
			if (defined $v){
				$stats{$stat[0]}->{$stat[1]} = 0;
				$i++;
				if (!$isWin){
					$java_home = _resolveLinks ($java_home);
				}
				$self->AddMessage ("Found $v->[0] ".($v->[1] ? '64bit' : '32bit')." in $java_home (\$JAVA_HOME)");
				push @javas, [$test_java, $java_home, @$v];
			}
		}
	}
	
	my $java_path;
	my $pattern_bin = '(.*)' . quotemeta ("${path_separator}bin${path_separator}java");
	my $pattern_nobin = '(.*)' . quotemeta ("${path_separator}java");
	foreach $test_java (which($isWin ? 'javaw' : 'java')){
		$v = _get_java_version($test_java);
		if (defined $v){
			if (!$isWin){
				$test_java = _resolveLinks ($test_java);
				($java_path) = ($test_java =~ /$pattern_bin/);
				if( ! defined $java_path ){
					next;
				}
				@stat = stat ($java_path);
				if (exists $stats{$stat[0]} && exists $stats{$stat[0]}->{$stat[1]}){
					next;
				}
				$java_path = _resolveLinks ($java_path);	
			}
			else{
				($java_path) = ($test_java =~ /$pattern_bin/);
				if (!$java_path){
					($java_path) = ($test_java =~ /$pattern_nobin/);
				}
				
			}
			$stats{$stat[0]}->{$stat[1]} = $i++;
			$self->AddMessage ("Found $v->[0] ".($v->[1] ? '64bit' : '32bit')." in $java_path (\$PATH)");
			push @javas, [$test_java, $java_path, @$v]; 
		}	
	}
	return \@javas;
}


sub _get_java_version{
	my ($java, $msglst) = @_;
	my $version;

	my $cfg = {'out' => \$version};
	
	my $rc = exec_program ($java,['-version'], $cfg);
	
	if (!defined $rc || $rc != 0){
		if (defined $msglst){
			$msglst->AddError ('Error executing Java VM', $cfg);
		}
		return undef;
	}
	
	my $is64bit = ($version =~ /64-bit|amd64|x86-64/im ? 1 : 0);
	
	($version) = ($version =~ /\"(.*)\"/);

	if (!$version){
		if (defined $msglst){
			$msglst->AddError ('Cannot parse version string', $cfg);
		}
		return undef;
	}
	return [$version, $is64bit];
}

1;
