package SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierFactory;
use strict;
use warnings;

use SDB::Install::System qw(isAdmin);
use SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierRoot;
use SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierSidadm;

sub getInstance{
    my ($self, $configuration, $component) = @_;
    my $class;
    if(isAdmin()){
        $class = SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierRoot->new($configuration, $component);
    }else {
        $class = SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierSidadm->new($configuration, $component);
    }
    return $class;
}

1;