package SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierSidadm;

use strict;
use File::Basename qw(dirname);
use parent qw(SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierBase);

sub execute{
    my ($self) = @_;
    return $self->_executeSHAOperation();
}

sub _buildSHAOptionsMap {
    my ($self) = @_;
    my $config = $self->getConfiguration();
    my $component = $self->getComponent();
    my $manifest = $component->getManifest()->getFileName();
    return {
        'COMPONENT_MANIFEST_DIR' => dirname($manifest),
        'SID' => $config->getValue('SID'),
        'TRUST_LEVEL' => $self->getTrustLevel(),
    };
}

sub getSHAOperation{
    return 'HdblcmModifyComponentTrustLevel_v1';
}

1;