#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Buffered list view. Inherit from Wx::ListCtrl.

package SDB::Install::LogViewer::Control::XLVListCtrl;

our @ISA = qw (Wx::ListCtrl);
use strict;

use Wx::Event qw(

                );

use Wx qw (
            wxLIST_AUTOSIZE
            wxVERTICAL
            wxEVT_SCROLL_LINEDOWN
            wxEVT_SCROLL_THUMBTRACK
            wxEVT_SCROLL_THUMBRELEASE
            wxEVT_SCROLLWIN_THUMBRELEASE
            wxEVT_UPDATE_UI
            wxEVT_COMMAND_SCROLLBAR_UPDATED
          );

sub new{
    my($self ) = shift->SUPER::new(@_);
    $self->InsertColumn(1,"Column 1");
    $self->SetColumnWidth(0, 3000);
    #$self->SetColumnWidth(0, wxLIST_AUTOSIZE);
    return $self;
}

sub ShowPosition {
    my($self, $pos) = @_;

    #this sucks
    #$self->SetScrollPos (wxVERTICAL, $pos, 1);
    
    # this sucks, too    
    #if ($^O =~ /mswin/i) {
    #    my $realtivscroll = ($pos - $self->GetScrollPos (wxVERTICAL));
    #    my $pages = int ($realtivscroll / $self->GetCountPerPage());
    #    $self->ScrollPages($pages);
    #    my $lines = $realtivscroll % $self->GetCountPerPage();
    #    $self->ScrollLines($lines);
    #}
    
    # create Event... this sucks too
    #$self->AddPendingEvent( Wx::CommandEvent->new( wxEVT_COMMAND_SCROLLBAR_UPDATED ,$self->GetId ) );
    
    # this ~works
    $self->EnsureVisible($pos);
    1;   
}

sub SetValue {
    my($self, $value) = @_;
    # split value to rows
    $self->{count} = 0;
	my $row;
    foreach $row (split "\n", $value) {
        $self->{$self->{count}} = $row;
        $self->{count} += 1;
    }
    
    $self->SetItemCount( $self->{count});
    
    $self->Refresh;
}

# this method is call by ListCtrl itself
sub OnGetItemText {
  my( $self, $item, $column ) = @_;
  return $self->{ $item };
}

sub GetMaxLine {
    my($self) = @_;
    if (!exists $self->{count}) {
        return 0;
    }
    return $self->{count};
}

#------------------ Seek & Destroy ------------------

sub Destroy{
    my ($self) = @_;
    $self->SUPER::Destroy;
}

1;