#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Dialog for type filter. 

package SDB::Install::LogViewer::Filter::TypeDialog;

use strict;

use vars qw(@ISA);
@ISA=qw(Wx::Dialog);

use Wx qw(
        wxDEFAULT_DIALOG_STYLE
        wxLI_HORIZONTAL
        wxCB_READONLY
        wxEXPAND
        wxALL
        );

use Wx::Event qw(
       EVT_BUTTON
       );

use SDB::Install::LogViewer::Filter::TypeFilter;


##
# Constructor for dialog initialisation.
#
# @param
#   scalar        - titel
#   Wx::Point     - Position
#   Wx::Size      - size
#   CacheTree     - content tree
#   FilterHandler - filter handler
##

sub new {
    my( $class ) = shift;
    my( $self ) = $class->SUPER::new( undef, -1, $_[0], $_[1], $_[2], wxDEFAULT_DIALOG_STYLE );
    $self->{CACHE} = $_[3];
    $self->{FILTERHANDLER} = $_[4];
    
    my $masterSizer = Wx::FlexGridSizer->new(3,1,5,5);
    
    #
    #   Content
    #
    my $contentsizer = Wx::FlexGridSizer->new(2,2,10,10);
    my @ReqExk = ("Require","Exclude");
    
    $self->{'filter_label'} = Wx::StaticText->new ($self, -1, 'Filter:');
    $self->{'filter_reqexc_combo'} = Wx::ComboBox->new ($self, -1,$ReqExk[0], [-1,-1],[-1,-1],\@ReqExk, wxCB_READONLY);
    $self->{'filter_label2'} = Wx::StaticText->new ($self, -1, '_TYPE:');
    my @_typelist = $self->{CACHE}->GetDifferentAttributeValuesByName('_TYPE');
    push @_typelist, 'Info (default)' if (scalar @_typelist ne 0);
    $self->{'filter_type_combo'} = Wx::ComboBox->new ($self, -1,($_typelist[0])?($_typelist[0]):(''), [-1,-1],[-1,-1],\@_typelist, wxCB_READONLY);
    $contentsizer->Add ($self->{'filter_label'},1, wxEXPAND);
    $contentsizer->Add ($self->{'filter_reqexc_combo'},1,wxEXPAND);
    $contentsizer->Add ($self->{'filter_label2'},1, wxEXPAND);
    $contentsizer->Add ($self->{'filter_type_combo'},1, wxEXPAND);

    $contentsizer->AddGrowableRow( 0 );
    $contentsizer->AddGrowableRow( 0 );
    $contentsizer->AddGrowableCol( 1 );
    $contentsizer->AddGrowableCol( 1 );
        
    $masterSizer->Add ($contentsizer, 1, wxEXPAND | wxALL , 10);
    
    #
    #   Horizontal Line
    #
    
    $self->{'masterline'} = Wx::StaticLine->new( $self, -1, [-1,-1], [-1,2], wxLI_HORIZONTAL);
    $masterSizer->Add ($self->{'masterline'}, 1, wxEXPAND ,);
    
    #
    #   Buttons
    #
    
    my $buttonsizer = Wx::FlexGridSizer->new(1,2,10,10);
    $self->{'cancel_button'} = Wx::Button->new ($self, -1, 'Cancel');
    $self->{'set_button'} = Wx::Button->new ($self, -1, 'Set');
    $self->{'set_button'}->Enable(0) if (scalar @_typelist eq 0);
    $buttonsizer->Add ($self->{'cancel_button'},1, );
    $buttonsizer->Add ($self->{'set_button'},1, );
    $masterSizer->Add ($buttonsizer, 1, wxEXPAND | wxALL , 10);

    #---------Events-------------
    
    #Cancel-Button
    EVT_BUTTON( $self, $self->{'cancel_button'}->GetId, \&OnClose );
    
    #Set Filter Button
    EVT_BUTTON( $self, $self->{'set_button'}->GetId, sub {
        my ($self,$evt) = @_;
        $self->{FILTERHANDLER}->AddFilter (
            SDB::Install::LogViewer::Filter::TypeFilter->new(
                                                            $self->{'filter_reqexc_combo'}->GetValue(),
                                                            $self->{'filter_type_combo'}->GetValue()
                                                            ));
        $self->Destroy();
      } );

    #---------Other stuff-------------
    
    $self->SetSizerAndFit($masterSizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    $self;
}


##
# Boring close method.
##

sub OnClose {
  my( $this, $event ) = @_;
  
  $this->Destroy();
}


##
# Destroyer method.
##

sub Destroy{
	my ($self) = @_;
	
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #
    foreach my $element (
                        'set_button', 
                        'cancel_button',
                        'filter_label',
                        'filter_reqexc_combo',
                        'filter_label2',
                        'filter_type_combo',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}

1;