package SDB::Install::Persistence::XMLGenerator;

use strict;
use SDB::Install::Persistence::Schema;
use parent 'SDB::Install::Base';

my $XML_VERSION = '1.0';
my $XML_ENCODING = 'UTF-8';
my %XML_TAG_TO_GETTER_MAP = (
    'source_version' => \&getSourceVersionString,
    'target_version' => \&getTargetVersionString,
    'date' => \&getCreationDateString,
    'next_phase' => \&getNextPhaseString,
    'component_name' => \&getComponentNameString,
    'action' => \&getActionString,
    'step' => \&getCurrentStepString,
    'extensions' => \&getExtensions,
);

sub addExtension {
    my ($self, $key, $value) = @_;
    $self->{extensions} //= {};
    $self->{extensions}->{$key} = $value;
}

sub getExtensions {
    my ($self) = @_;
    return $self->{extensions};
}

sub setSourceVersionString {
    my ($self, $sourceVersionString) = @_;
    $self->{_componentSourceVersion} = $sourceVersionString;
}

sub getSourceVersionString {
    my ($self) = @_;
    return $self->{_componentSourceVersion};
}

sub setTargetVersionString {
    my ($self, $targetVersionString) = @_;
    $self->{_componentTargetVersion} = $targetVersionString;
}

sub getTargetVersionString {
    my ($self) = @_;
    return $self->{_componentTargetVersion};
}

sub setCreationDateString {
    my ($self, $dateString) = @_;
    $self->{_creationDate} = $dateString;
}

sub getCreationDateString {
    my ($self) = @_;
    return $self->{_creationDate};
}

sub setNextPhaseString {
    my ($self, $nextPhase) = @_;
    $self->{_nextPhase} = $nextPhase;
}

sub getNextPhaseString {
    my ($self) = @_;
    return $self->{_nextPhase};
}

sub setComponentNameString {
    my ($self, $componentName) = @_;
    $self->{_componentName} = $componentName;
}

sub getComponentNameString {
    my ($self) = @_;
    return $self->{_componentName};
}

sub setActionString {
    my ($self, $action) = @_;
    $self->{_action} = $action;
}

sub getActionString {
    my ($self) = @_;
    return $self->{_action};
}

sub setCurrentStepString {
    my ($self, $stepName) = @_;
    $self->{_stepName} = $stepName;
}

sub getCurrentStepString {
    my ($self) = @_;
    return $self->{_stepName};
}

sub generatePersistenceXMLString {
    my ($self) = @_;
    my $document = $self->_generateXMLDocument();

    eval {
        SDB::Install::Persistence::Schema::validate($document);
    };
    if($@) {
        $self->setErrorMessage("Invalid XML format: $@");
        return undef;
    }
    return $document->toString(1);
}

#
# Only private subs below this line
#

sub _generateXMLDocument {
    my ($self) = @_;
    require XML::LibXML;
    my $document = XML::LibXML::Document->new($XML_VERSION, $XML_ENCODING);
    my $rootElement = $self->_createXmlRootElement($document);
    $document->setDocumentElement($rootElement);

    $self->setCreationDateString($self->_getCurrentXsDateTime()) if (! defined $self->getCreationDateString());

    while (my($tagName, $getterSub) = each %XML_TAG_TO_GETTER_MAP) {
        my $content = $getterSub->($self);
        next if !defined($content);

        my $element = $self->_createXmlElement($tagName, $content);
        $rootElement->appendChild($element);
    }

    return $document;
}

sub _getCurrentXsDateTime {
    my ($self) = @_;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
    $mon++;
    $year += 1900;
    return sprintf ("%04d-%02d-%02dT%02d:%02d:%02d", $year, $mon, $mday, $hour, $min, $sec);
}

sub _createXmlRootElement {
    my ($self, $document) = @_;
    my $rootElement = $document->createElement('tns:persistence');

    $rootElement->setAttribute('xmlns:tns', 'http://www.hdblcm.org/persistence');
    $rootElement->setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
    $rootElement->setAttribute('xsi:schemaLocation', 'http://www.hdblcm.org/persistence/persistence.xsd');

    return $rootElement;
}

sub _createXmlElement {
    my ($self, $tagName, $content) = @_;
    if (ref($content) eq 'HASH') {
        my $element = XML::LibXML::Element->new($tagName);
        my @children = map { $self->_createXmlElement($_, $content->{$_}) } keys %{$content};
        $element->appendChild($_) for @children;
        return $element;
    }
    return $self->_createTextElement($tagName, $content);
}

sub _createTextElement {
    my ($self, $tagName, $text) = @_;
    my $element = XML::LibXML::Element->new($tagName);
    $element->appendText($text);
    return $element;
}

1;