package SDB::Install::PersistencyMngr;

use base SDB::Install::BaseLegacy;

use SDB::Install::Tools qw (readini iso8601DateTime);
use LCM::FileUtils qw (changeFileOwnership changeFilePermissions);

sub pers_load{
	my ($self, $file) = @_;

	my $hash = {};

	my $filename = (defined $file) ? $file : $self->pers_filename();

	if (!defined $filename) {
		$self->AddError ("Cannot detect persfile name", $self);
		return undef;
	}

	if (!-f $filename) {
		$self->setErrorMessage ("Cannot open file '$filename': $!");
	}

	my $msg = $self->AddMessage ("Loading setting from previous run ($filename)...");
	my $errMsgLst = new SDB::Install::MsgLst( );
	my $data = readini ($filename, $errMsgLst, 1);
	if (!defined $data){
		$self->AddError("Cannot read status file '$filename'");
		$self->getErrMsgLst()->appendMsgLst ($errMsgLst);
		return undef;
	}

	my $persdata = $data->{''};

	foreach my $key (sort keys %$persdata){
		if (scalar @{$persdata->{$key}} == 1) {
			$self->_setValueToKey($hash, $persdata, $key, $msg);
		} else {
			# Multiple values in ini file
			$self->_setHashToKey($hash, $persdata, $key, $msg);
		}
	}

	return $hash;
}


sub _setValueToKey {
	my ($self, $hash, $persdata, $key, $msg) = @_;

	$hash->{$key} = $persdata->{$key}->[0];
	$self->AddSubMessage ($msg, "$key = $persdata->{$key}->[0]");
}


sub _setHashToKey {
	my ($self, $hash, $persdata, $key, $msg) = @_;

	foreach my $keyValuePair (@{$persdata->{$key}}) {
		$self->AddSubMessage ($msg, "$key = $keyValuePair");
		if ($keyValuePair =~  /([^=]*)=(.*)/) {
			if (!defined $1 || !defined $2) {
				next;
			}
			$hash->{$key}->{$1} = $2;
		}
	}
}


sub pers_store{
	my ($self,$file, $hash) = @_;

    my $filename = (defined $file) ? $file : $self->pers_filename();

    if (!defined $filename) {
        $self->AddError ("Persfile name is undefined", $self);
        return undef;
    }

    if (!open (FH, '>' . $filename)){
        $self->AddError ("Cannot create file '$filename': $!");
        return 0;
    }

    if (!defined $hash){
        $hash = $self;
    }

    foreach my $key (sort keys %$hash) {
        my $value = $hash->{$key};
        my $refType =  ref($value);
        if (!defined $value){
            next;
        }
        if (defined $refType && $refType eq 'HASH'){
            foreach my $hashKey (sort keys %$value){
                if (!print FH "$key=$hashKey=$value->{$hashKey}\n") {
                    $self->AddError ("Cannot write into file '$filename': $!");
                    close(FH);
                    return 0;
                }
            }
            next;
        }
        if (!print FH "$key=$value\n") {
            $self->AddError ("Cannot write into file '$filename': $!");
            close(FH);
            return 0;
        }
    }

    if (!close (FH)) {
        $self->AddError ("Cannot close created file '$filename': $!");
        return 0;
    }

    my ($uid, $gid, $fileMode) = $self->getPersistenceFileModifiers();

    if (defined $uid
        && defined $gid
        && !changeFileOwnership($filename, $uid, $gid, $self->getMsgLst())) {

        return 0;
    }

    if (defined $fileMode
        && !changeFilePermissions($filename, $fileMode, $self->getMsgLst())) {

        return 0;
    }

	return 1;
}

sub pers_exists{
    my ($self, $file) = @_;

    my $filename = (defined $file) ? $file : $self->pers_filename ();

    if (!defined $filename) {
        return undef;
    }

    if (-f $filename) {
        $self->{_pers_date} = (stat (_)) [9];
        return 1;
    }
    return 0;
}


sub pers_date_string{
    return iso8601DateTime ($_[0]->{_pers_date});
}

sub pers_remove{

    my ($self, $file) = @_;

    my $filename = (defined $file) ? $file : $self->pers_filename();

    if (!defined $filename) {
        $self->AddMessage ('Status file not defined');
        return 1;
    }

    delete $self->{_pers_date};

    if (-f $filename) {
        if (!unlink ($filename)) {
            $self->getErrMsgLst()->addError
                                  ("Cannot remove status file '$filename': $!");
            return undef;
        }
        $self->AddMessage ("Status file '$filename' removed");
    }
    else {
        $self->AddMessage ("Status file '$filename' not found");
    }
    return 1;
}

sub getPersistenceFileModifiers {
	my ($uid, $gid, $fileMode) = (undef, undef, undef);
	return ($uid, $gid, $fileMode);
}

1;
