package SDB::Install::PythonExecutor;

use base SDB::Install::BaseLegacy;
use SDB::Install::System;
use SDB::Install::SysVars;

our $python;

sub findSystemPython {
    if (!$python){
        $python = which ('python');
        if (!defined $python && !$isWin){
            local %ENV = %ENV;
            $ENV{PATH} = join ($env_path_separator, qw(/usr/bin /usr/local/bin));
            $python = which ('python');
        }
    }
    return $python;
}

sub new{
    my $self = shift->SUPER::new ();
    my ($pythonPath) = @_;
    $self->{python} = $pythonPath // findSystemPython();
    $self->{stdOutLines} = undef;
    return $self;
}

sub setScript{
    if (-f $_[1]){
        $_[0]->{'script'} = $_[1];
        return 1;
    }
    $_[0]->AddError ("'$_[1]' $!");
    return undef;
}


sub runScript{
    my ($self, $args, $uid, $gid) = @_;
    $self->{stdOutLines} = undef;
    my $cfg = {};
    if (defined $uid) {
        $cfg->{UID} = $uid;
    }
    if (defined $gid) {
        $cfg->{GID} = $gid;
    }
    $cfg->{outLines} = [];
    if (!defined $args){
        $args = [];
    }
    if (!defined $self->{python}){
        $self->AddError ("No python interpreter defined\n");
        return undef;
    }

    if (!defined $self->{script}){
        $self->AddError ("No python script defined\n");
        return undef;
    }
    local %ENV = %ENV;
    $ENV{PYTHONDONTWRITEBYTECODE} = 'x';
    my $rc = exec_program ($self->{python}, [$self->{script}, @$args], $cfg);
    if (!defined $rc || $rc != 0){
        $self->getErrMsgLst->addError ("Performing python script failed", $cfg);
        $self->AddMessage (undef, $cfg);
        return undef;
    }
    $self->AddMessage (undef, $cfg);
    $self->{stdOutLines} = $cfg->{outLines};
    return 1;
}

sub getStdOutLines {
    return $_[0]->{stdOutLines};
}

sub setPython {
    my ($self, $pythonPath) = @_;
    $self->{python} = $pythonPath;
}

1;

