package SDB::Install::SAPInstance::TenantDatabase;

use strict;
use SDB::Install::Configuration qw($bool_true_pattern);

sub new {
    my ($class, $tenantInfo) = @_;
    # $tenantInfo is ARRAYREF
    my $self = bless($tenantInfo, $class);
    return $self;
}

sub getName {
    my ($self) = @_;
    return $self->[0];
}

sub getContainer {
    my ($self) = @_;
    return $self->[1];
}

sub getUsername {
    my ($self) = @_;
    return $self->[2];
}

sub getGroupname {
    my ($self) = @_;
    return $self->[3];
}

sub getUserID {
    my ($self) = @_;
    return $self->[4];
}

sub getGroupID {
    my ($self) = @_;
    return $self->[5];
}

sub getHost {
    my ($self) = @_;
    return $self->[6];
}

sub getPort {
    my ($self) = @_;
    return $self->[7];
}

sub isActive {
    my ($self) = @_;
    my $isActiveString = $self->[8];
    return $isActiveString && $isActiveString =~ /$bool_true_pattern/;
}

1;
