package SDB::Install::SAPSystemContainerHelper::InitSSFSContainerHelper;

use strict;
use SDB::Install::SAPSystemUtilities;
use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::IOHelper;
use SDB::Install::SysInfo;
use SDB::Install::OSConfig;
use SDB::Install::SAPInstance::TrexInstance;
use SDB::Install::SAPSystem;

our @ISA = qw (SDB::Install::Base SDB::Install::SAPSystemUtilities);


sub performContainerAction {
    my ($self, $instconfig, $sapSys) = @_;
    my $msglst = $self->getMsgLst();

    my $instance = $sapSys->getNewDBInstances()->[0];

    my $msg = $msglst->addProgressMessage ('Preparing filesystem...');
    $sapSys->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!$sapSys->createFs ($instance->get_nr(), $sapSys->getVersionIdString())){
        $self->setErrorMessage ("Cannot prepare filesystem", $sapSys->getErrMsgLst ());
        return undef;
    }

    $msg = $msglst->addProgressMessage ('Initializing sapstartsrv system pki...');
    $instance->setMsgLstContext ([$msg->getSubMsgLst()]);

    if (!defined $instance->startLocalSapStartSrv ()){
        $self->setErrorMessage ("Cannot start local sapstartsrv", $instance->getErrMsgLst ());
        return undef;
    }

    my $sapcontrol = new SDB::Install::SAPControl (undef, $instance->get_nr());
    my $submsg = $msg->getSubMsgLst()->addMessage ("Performing SAPControl::UpdateSystemPKI()...");
    $sapcontrol->setMsgLstContext ([$submsg->getSubMsgLst()]);
    if (!defined $sapcontrol->updateSystemPKI()){
        $self->setErrorMessage ("Cannot initialize sapstartsrv system pki", $sapcontrol->getErrMsgLst ());
        return undef;
    }
    $sapcontrol->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!defined $sapcontrol->stopServiceWait()){
        $self->setErrorMessage ("Cannot stop local sapstartsrv", $sapcontrol->getErrMsgLst ());
        return undef;
    }

    $msg = $msglst->addProgressMessage ('Initializing HANA system pki and secure store...');
    $instance->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!defined $instance->createSecureStoreAndSSFSKeys($instconfig)){
        $self->setErrorMessage ("Cannot initialize HANA secure store and system pki", $instance->getErrMsgLst ());
        return undef;
    }
    return 1;
}

1;
