package SDB::Install::SAPSystemContainerHelper::UpdateContainerHelper;

use strict;
use SDB::Install::SAPSystemUtilities;
use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::IOHelper;
use SDB::Install::SysInfo;
use SDB::Install::OSConfig;
use SDB::Install::SAPSystem;
use SDB::Install::SAPInstance::TrexInstance;

our @ISA = qw (SDB::Install::Base SDB::Install::SAPSystemUtilities);


#-------------------------------------------------------------------------------
# update a docker container after switch to new software version
# This method is called from SDB::Install::App::Console::<tbd>
#
# Parameters: $instconfig  SDB::Install::Configuration::ContainerHelper
#             $sapSys      SDB::Install::SAPSystem
#
# Returns int retCode


sub performContainerAction {
    my ($self, $instconfig, $sapSys) = @_;
    my $instance = $sapSys->getNewDBInstances()->[0];
    my $msglst   = $self->getMsgLst();

    my $msg = $msglst->addProgressMessage("Configuring file system...");
    my $fsMan = $sapSys->getFileSystemManager();
    $fsMan->setMsgLstContext([$msg->getSubMsgLst()]);
    if (!defined $fsMan->migrate()){
        $self->setErrorMessage("Cannot configure file system", $fsMan->getErrMsgLst());
        return undef;
    }

    $msg = $msglst->addProgressMessage('Configuring admin user...');
    my $user = $sapSys->getUser();
    $user->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!defined $user->adaptExistingUser()){
        $self->setErrorMessage("Cannot configure admin user", $user->getErrMsgLst());
        return undef;
    }

    $msg = $msglst->addProgressMessage('Configuring HANA instance...');
    $instance->setMsgLstContext([$msg->getSubMsgLst()]);
    if (!defined $instance->migrate ($instconfig, $sapSys->getFileSystemManager())){
        $self->setErrorMessage('Configure HANA instance failed', $self->getErrMsgLst());
        return undef;
    }

    $msg = $msglst->addProgressMessage("Updating environment scripts...");
    $instance->setMsgLstContext([$msg->getSubMsgLst ()]);
    if (!defined $instance->installHDBScripts()){
        $self->setErrorMessage("Error updating environment scipts", $instance->getErrMsgLst());
        return undef;
    }

    return 1;
}

1;
