package SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation::AflOnlineInstallation;

use strict;
use warnings;

use base 'SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation';

our $PROCEDURE_INSTALL   = 'SYS.AFLPM_ONLINE_REGISTRATION_INSTALL';
our $SQL_CALL_INSTALL    = "CALL $PROCEDURE_INSTALL (?)";

our $PROCEDURE_RESTART   = 'SYS.AFLPM_ONLINE_REGISTRATION_RESTART_SCRIPTSERVERS';
our $SQL_CALL_RESTART    = "CALL $PROCEDURE_RESTART (?,?)";

our $SKIP_RESTART_MSG    = 'Skipping scriptserver restart due to --no_scriptserver_restart';

sub _getAction{
    return 'installation';
}

sub checkPreconditionOffline{
    my ($self) =  @_;
    if (!$self->SUPER::checkPreconditionOffline()){
        return 0;
    }
    $self->{isRestartRequired} = $self->{pluginManifest}->isServerPluginOnlineInstallableWithRestart();
    if($self->{isRestartRequired}){
        my $msglst = $self->_getCheckPreparationMsgLst();
        $msglst->addMessage("Server plugin online registration requires scriptserver restart");
    }
    return 1;
}

sub checkPreconditionOnline{
    my ($self, $sqlConnection) = @_;
    if (!$self->SUPER::checkPreconditionOnline($sqlConnection)){
        return 0;
    }
    $self->{sqlConnection} = $sqlConnection;
    if (!$self->{isRestartRequired}){
        return 1;
    }
    my $msg = $self->getMsgLst()->addMessage("Checking database whether online installation with scriptserver restart is supported");
    my $rc = $self->_dbProcExists($PROCEDURE_RESTART, $msg->getSubMsgLst());
    if (!$rc && $self->{noScriptServerRestart}){
        $self->getMsgLst()->addMessage($SKIP_RESTART_MSG);
        $rc = 1;
    }
    return $rc;
}

sub do{
    my ($self) = @_;
    if ($self->{onlineOperationOk}){
        my $msg = $self->getMsgLst()->addProgressMessage("Finalizing ONLINE REGISTRATION");
        $self->{onlineOperationOk} = $self->_callDBProcWithParams($SQL_CALL_INSTALL, [$self->{pluginKey}], undef, $msg->getSubMsgLst());
    }
    $self->restartScriptServer();
    $self->cleanup();
    return $self->{onlineOperationOk};
}

sub isScriptServerRestartRequired{
    my ($self) = @_;
    return $self->{isRestartRequired};
}

sub setNoScriptServerRestart{
    my ($self) = @_;
    $self->{noScriptServerRestart} = 1;
    return 1;
}

sub restartScriptServer{
    my ($self) = @_;
    if (!$self->{onlineOperationOk} || !$self->{isRestartRequired}){
        return 1;
    }
    if ($self->{noScriptServerRestart}){
        $self->getMsgLst()->addMessage($SKIP_RESTART_MSG);
        return 1;
    }
    my $msg = $self->getMsgLst()->addProgressMessage("Restarting scriptserver");
    $self->{onlineOperationOk} = $self->_callDBProcWithParams($SQL_CALL_RESTART, [$self->{pluginKey}, 'PLUGINS-SUBDIR'], undef, $msg->getSubMsgLst());
    return $self->{onlineOperationOk};
}

1;
