package SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation::AflOnlineUninstallation;

use strict;
use warnings;

use base 'SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation';

our $PROCEDURE_UNINSTALL = 'SYS.AFLPM_ONLINE_REGISTRATION_DEINSTALL';
our $SQL_PREPARE_UNINSTALL    = "CALL $PROCEDURE_UNINSTALL (?)";

sub _getAction{
    return 'uninstallation';
}

sub checkPreconditionOnline{
    my ($self, $sqlConnection) = @_;
    if (!$self->SUPER::checkPreconditionOnline($sqlConnection)){
        return 0;
    }
    $self->{sqlConnection} = $sqlConnection;
    my $msg = $self->getMsgLst()->addMessage("Checking database whether online uninstallation is supported");
    return $self->_dbProcExists($PROCEDURE_UNINSTALL, $msg->getSubMsgLst());
}

sub do{
    my ($self) = @_;
    if ($self->{onlineOperationOk}){
        my $msg = $self->getMsgLst()->addProgressMessage("Finalizing ONLINE UNREGISTRATION");
        $self->{onlineOperationOk} = $self->_callDBProcWithParams($SQL_PREPARE_UNINSTALL, [$self->{pluginKey}], undef, $msg->getSubMsgLst());
    }
    $self->cleanup();
    return $self->{onlineOperationOk};
}

1;
