package SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation::AflOnlineUpdate;

use strict;
use warnings;

use base 'SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation';


our $SQL_PREPARE_INITIALIZE = 'CALL SYS.AFLPM_ONLINE_REGISTRATION_INITIALIZE (?)';
our $SQL_PREPARE_FINALIZE = 'CALL SYS.AFLPM_ONLINE_REGISTRATION_FINALIZE (?)';

sub new{
    my ($class, $srcPluginKey, $srcPluginManifest, $pluginKey, $pluginManifest) = @_;
    my $self = $class->SUPER::new($pluginKey, $pluginManifest);
    $self->{srcPluginKey} = $srcPluginKey;
    $self->{srcPluginManifest} = $srcPluginManifest;
    return $self;
}

sub _getAction{
    return 'update';
}

sub checkPreconditionOffline{
    my ($self) =  @_;
    my $msglst = $self->_getCheckPreparationMsgLst();
    my $rc = $self->{pluginManifest}->isServerPluginOnlineUpdatable();
    if ($rc){
        $msglst->addMessage(sprintf('New server plugin supports online %s', $self->_getAction()));
    }
    else{
        $msglst->addMessage(sprintf('New server plugin doesn\'t support online %s.', $self->_getAction()));
        return $rc;
    }
    $rc = $self->{srcPluginManifest}->isServerPluginOnlineUpdatable();
    if ($rc){
        $msglst->addMessage(sprintf('Already installed server plugin supports online %s as well.', $self->_getAction()));
    }
    else{
        $msglst->addMessage(sprintf('Installed server plugin doesn\'t support online %s,', $self->_getAction()));
    }
    return $rc;
}

sub prepare{
    my ($self) = @_;
    my $msg = $self->getMsgLst()->addProgressMessage ("Initializing ONLINE REGISTRATION");
    $self->{onlineOperationOk} = $self->_callDBProcWithParams($SQL_PREPARE_INITIALIZE, [$self->{srcPluginKey}], undef, $msg->getSubMsgLst());
    return $self->{onlineOperationOk};
}

sub do{
    my ($self) = @_;
    if ($self->{onlineOperationOk}){
        my $msg = $self->getMsgLst()->addProgressMessage("Finalizing ONLINE REGISTRATION");
        $self->{onlineOperationOk} = $self->_callDBProcWithParams($SQL_PREPARE_FINALIZE, [$self->{pluginKey}], undef, $msg->getSubMsgLst());
    }
    $self->cleanup();
    return $self->{onlineOperationOk};
}

1;
