package SDB::Install::ServerPluginOnlineOperation::NonAflOnlineUpdate;

use strict;
use warnings;

use base 'SDB::Install::ServerPluginOnlineOperation';
use SDB::Common::Utils qw (trim);


sub new{
    my ($class, $pluginKey, $pluginManifest) = @_;
    my $self = $class->SUPER::new($pluginKey, $pluginManifest);
    $self->{result} = undef;
    return $self;
}

sub _getAction{
    return 'update';
}

sub checkPreconditionOffline{
    my ($self) =  @_;
    my $msglst = $self->_getCheckPreparationMsgLst();
    my $rc = $self->{pluginManifest}->isNonAflServerPluginOnlineUpdatable();
    if ($rc){
        $msglst->addMessage(sprintf('Server plugin (non-AFL) supports online %s', $self->_getAction()));
    }
    else{
        $msglst->addMessage(sprintf('Server plugin (non-AFL) doesn\'t support online %s.', $self->_getAction()));
    }
    return $rc;
}

sub checkSqlUser{
    my ($self) = @_;
    my $fullyQualifiedProcName = $self->{pluginManifest}->getNonAflServerPluginOnlineUpdateProcedureName();
    my ($schemaName, $procName) = split(/\./, $fullyQualifiedProcName);
    return $self->_checkSqlUserDBProcExecutePermission($schemaName, $procName);
}

# for non-AFL server plugins this is a noop:
sub prepare{
    my ($self) = @_;
    $self->{onlineOperationOk} = 1;
    return $self->{onlineOperationOk};
}

sub do{
    my ($self) = @_;
    if ($self->{onlineOperationOk}){
        my $procName = $self->{pluginManifest}->getNonAflServerPluginOnlineUpdateProcedureName();
        my $pluginKey = $self->{pluginKey};
        my $progTmpl = "Finalizing online %s of non-AFL server plugin '%s'...";
        my $msg = $self->getMsgLst()->addProgressMessage(sprintf($progTmpl, $self->_getAction(), $pluginKey));
        $self->{onlineOperationOk} = $self->_callDBProcWithParams("CALL $procName (?)", [ \$self->{result} ], [ 5001 ]);
        if (!$self->{onlineOperationOk}){
            my $errtxt = "Cannot call non-AFL server plugin online update db procedure '$procName' for plugin '$pluginKey'.";
            $self->setErrorMessage ($errtxt);
            $self->{onlineOperationOk} = 0;
        }
        else {
            my $resultText = "Result of non-AFL server plugin online update db procedure '$procName' for plugin '$pluginKey'";
            if (!defined $self->{result}){
                my $errtxt = "$resultText is undefined.";
                $self->setErrorMessage ($errtxt);
                $self->{onlineOperationOk} = 0;
            }
            else {
                $self->{result} =~ s/\0+$//;
                $self->{result} = trim($self->{result});
                $self->getMsgLst()->addMessage("*************** $resultText: ***************");
                $self->getMsgLst()->addMessage("$self->{result}");
                $self->getMsgLst()->addMessage("*********** end of $resultText *************");
                my $json_struct = undef;
                eval {
                    local %ENV = %ENV;
                    $ENV{PERL_JSON_BACKEND} = 'JSON::backportPP';
                    require JSON;
                    $json_struct = JSON::from_json($self->{result});
                };
                if($@) {
                    my $errtxt = "Could not parse result of non-AFL server plugin online update db procedure '$procName' for plugin '$pluginKey'.";
                    $self->setErrorMessage ($errtxt);
                    $self->{onlineOperationOk} = 0;
                }
                if(!defined $json_struct->{return_code}) {
                    my $errtxt = "Return code not found in result of non-AFL server plugin online update db procedure '$procName' for plugin '$pluginKey'.";
                    $self->setErrorMessage ($errtxt);
                    $self->{onlineOperationOk} = 0;
                }
                elsif($json_struct->{return_code} ne '0') {
                    my $errtxt = "Nonzero return code from non-AFL server plugin online update db procedure '$procName' for plugin '$pluginKey'.";
                    $self->setErrorMessage ($errtxt);
                    $self->{onlineOperationOk} = 0;
                }
            }
        }
    }
    $self->cleanup();
    return $self->{onlineOperationOk};
}

sub cleanup{
    my ($self) = @_;
    if (!defined $self->{sqlConnection}){
        return 1;
    }
    delete $self->{sqlConnection};
    return 1;
}

1;
