package SDB::Install::System::IpcCleaner;

use warnings;
use strict;
use File::stat;
use LCM::ProcessExecutor;

use parent 'SDB::Install::Base';

sub _getProgramPath{
    my ($self, $prog) = @_;
    my ($progPath, $stat);
    foreach my $path ('/usr/bin','/bin','/usr/sbin', '/sbin'){
        $progPath = "$path/$prog";
        $stat = File::stat::stat($progPath);
        if (!defined $stat){
            next;
        }
        if (-x $stat){
            return $progPath;
        }
    }
    $self->setErrorMessage("Program '$prog' not found!");
    return undef;
}


sub _collectIpcResources{
    my ($self, $nocache) = @_;
    $nocache //= 0;
    if (defined $self->{_ipcResources} && !$nocache){
        return $self->{_ipcResources};
    }

    my $ipcs  = $self->_getProgramPath('ipcs');
    if (!defined $ipcs){
        return undef;
    }
    my $outbuffer;
    my $executor = new LCM::ProcessExecutor($ipcs, ['-a']);
    my $rc = $executor->executeProgram(1);
    if (!defined $rc){
        $self->setErrorMessage("Cannot execute 'ipcs -a'", $executor->getErrMsgLst());
        return undef;
    }
    if ($rc != 0){
        $self->setErrorMessage("Command 'ipcs -a' reported an error", $executor->getMsgLst());
        return undef;
    }

    my $ipc_resources = {};
    my (@columns, @row);
    my @out = @{$executor->getOutputLines()};
    my $head = 0;
    foreach my $i (0..$#out){
        if ($out[$i] !~ /\S/){
            next;
        }
        if ($out[$i] =~ /^--+/){
            $head = 1;
            next;
        }
        if ($head){
            @columns = split (/\s+/,$out[$i]);
            $head = 0;
            next;
        }
        @row = split (/\s+/,$out[$i]);
        if (@row > 2){
            if (!defined $ipc_resources->{$columns[1]}){
                $ipc_resources->{$columns[1]} = [[$row[1], $row[2]]];
            }
            else{
                push @{$ipc_resources->{$columns[1]}}, [$row[1], $row[2]];
            }
        }
    }
    $self->{_ipcResources} = $ipc_resources;
    return $ipc_resources;
}



sub cleanIpcResources{
    my ($self, $user) = @_;
    #
    # remove ipcs by user
    #
    my $msg = $self->getMsgLst()->addMessage("Removing IPCs by user ($user)");



    my $ipcrm = $self->_getProgramPath('ipcrm');

    if (!defined $ipcrm){
        return undef;
    }

    my $ipc_resources= $self->_collectIpcResources();

    if (!defined $ipc_resources){
        return undef;
    }
    my $ipcrm_switch;
    my $result = 1;
    foreach my $idname (keys (%$ipc_resources)){
        if ($idname eq 'shmid'){
            $ipcrm_switch = '-m';
        }
        elsif ($idname eq 'semid'){
            $ipcrm_switch = '-s';
        }
        elsif ($idname eq 'msqid'){
            $ipcrm_switch = '-q';
        }
        else{
            next;
        }
        foreach my $res (@{$ipc_resources->{$idname}}){
            if ($res->[1] eq $user){
                my $executor = new LCM::ProcessExecutor($ipcrm,[$ipcrm_switch, $res->[0]]);
                my $rc = $executor->executeProgram(1);
                if (!defined $rc){
                    $self->appendErrorMessage("Cannot execute '$ipcrm'", $executor->getErrMsgLst());
                    $result = 0;
                    next;
                }
                if ($rc != 0){
                    $self->appendErrorMessage("Command '$ipcrm' reported an error", $executor->getMsgLst());
                    $result = 0;
                    next;
                }
                $msg->getSubMsgLst()->addMessage("$idname $res->[0] removed");
            }
        }
    }
    return $result;
}

1;