package SDB::Install::System::Shortcut;

#
# module to handle shortcuts
#

use SAPDB::Install::System::Win32::API;
use SDB::Install::BaseLegacy;
use SDB::Install::SysVars;
use SDB::Install::System qw(makedir);

our @ISA = qw (SDB::Install::BaseLegacy);

sub new {
	my $self = shift->SUPER::new ();
	($self->{location}, $self->{target},$self->{name}, $flags) = @_;
	
	if (!$flags && $self->exists ()){
		$self->readShortcut ();
	}
	return $self;
}

sub setName{
	$_[0]->{name} = $_[1];
}

sub setComment{
	$_[0]->{comment} = $_[1];
}

sub setIcon{
	$_[0]->{icon} = $_[1];
}

sub setIconIndex{
	$_[0]->{iconIndex} = $_[1];
}

sub setWorkDir{
	$_[0]->{workDir} = $_[1];
}

sub setArgs{
	$_[0]->{args} = $_[1];
}

sub setRunAsAdmin{
	$_[0]->{runAsAdmin} = $_[1];
}

sub getName{
	$_[0]->{name};
}

sub getComment{
	$_[0]->{comment};
}

sub getIcon{
	$_[0]->{icon};
}

sub getIconIndex{
	$_[0]->{iconIndex};
}

sub getWorkDir{
	$_[0]->{workDir};
}

sub getArgs{
	$_[0]->{args};
}

sub getRunAsAdmin{
	$_[0]->{runAsAdmin};
}

sub existsUx{

}

sub existsWin{
	return -e $_[0]->{location} . '\\' . $_[0]->{name} . '.lnk';
}

sub exists;
*exists = $isWin ? \&existsWin : \&existsUx;

sub createUx{

}

sub createWin{
	my ($self) = @_;

	if (!$self->{location}){
		$self->AddError ("Cannot create shortcut '$self->{name}': location not defined");
		return undef;
	}
	
	if (!-e $self->{location}){
		my $cfg = {};
		if (!makedir ($self->{location}, $cfg)){
			$self->AddError ("Cannot create shortcut directory '$self->{location}'", $cfg);
			return undef;
		}
	}

	my $rc = SAPDB::Install::System::Win32::API::CreateShortcut(
                    $self->{target},
                    $self->{location} . '\\' . $self->{name} . '.lnk',
                    $self->{args},
                    $self->{comment},
                    $self->{workDir},
                    $self->{icon},
                    $self->{iconIndex},
                    $self->{runAsAdmin} ? 1 : 0);

	if ($rc != 0){
		$self->AddError ("Cannot create shortcut: Win32 API call failed");
		return undef;
	}

	return 1;
}

sub create;
*create = $isWin ? \&createWin : \&createUx;

sub deleteUx{

}

sub deleteWin{
	my ($self) = @_;
	my $lnk = $self->{location} . '\\' . $self->{name} . '.lnk';
	if (!unlink ($lnk)){
		$self->AddError ("Cannot delete shortcut '$lnk': $!");
		return undef;
	}
	return 1;
}

sub delete;
*delete = $isWin ? \&deleteWin : \&deleteUx;



sub readShortcutUx{

}

sub readShortcutWin{
	my ($self) = @_;
	my $lnk = $self->{location} . '\\' . $self->{name} . '.lnk';
	if (!-f $lnk){
		$self->AddError ("Cannot read shortcut '$lnk': $!");
		return undef;
	}

	my ($rc, @result) = SAPDB::Install::System::Win32::API::ShortcutInfo ($lnk);
	
	if ($rc != 0){
		$self->AddError ("Cannot read shortcut '$lnk': $result[0]");	
		return undef;
	}
	($self->{target}, $self->{comment}) = @result;
	return 1;	
}

sub readShortcut;
*readShortcut = $isWin ? \&readShortcutWin : \&readShortcutUx;

1;
