#! /usr/bin/perl
#

package BuildPackage::Init;

BEGIN{
    @INC = (@INC, '.');
    my $psep = ($^O =~ /mswin/i) ? ';' : ':';
    if ($SAPDB::Install::Config{'RuntimeDir'}){
        $ENV{'PATH'} = $SAPDB::Install::Config{'RuntimeDir'}.$psep.$ENV{'PATH'};
    }
    #
    # switch autoflush on:
    #

    $| = 1;
    my $stdout = select (STDERR);
    $| = 1;
    select ($stdout);

    foreach my $i (0..$#ARGV){
        if (($ARGV[$i] eq '-threads'  || $ARGV[$i] eq '--threads') && $ARGV[$i +1] > 1){
            require BuildPackage::Worker;
            BuildPackage::Worker::startWorker (int ($ARGV[$i +1]));
            last;
        }
    }
};

package BuildPackage::BuildPackage;

use Getopt::Long;
use BuildPackage::Vars;
use strict;

if ($^O =~ /mswin/i){
    require BuildPackage::PackZip;
    import BuildPackage::PackZip qw (pack_selfextracting_archive);
}

#-----------------------------------------------------------------------------

use Exporter;
our @ISA = ('Exporter');
our @EXPORT = qw(
    $Vars
);

our $Vars;

#-----------------------------------------------------------------------------

sub main{
    local @ARGV = @_;
    
    my $opt_help;
    my $opt_wrkdir;
    my $opt_makeoutpdir;
    my $opt_packdefdir;
    my $opt_threads;
    my $opt_makeid;
    my $opt_package;
    my $opt_config;
    my $opt_verbose;
    my $opt_kitname;
    my $opt_addenv;
    
    my %opt_ctrl = (
        'h',                       \$opt_help,
        'work=s',                  \$opt_wrkdir,
        'gen=s',                   \$opt_makeoutpdir,
        'packdef=s',               \$opt_packdefdir,
        'threads=i',               \$opt_threads,
        'makeid=s',                \$opt_makeid,
        'package=s',               \$opt_package,
        'config=s',                \$opt_config,
        'verbose',                 \$opt_verbose,
        'kitname=s',               \$opt_kitname,
        'addenv=s',                \$opt_addenv
    );
    Getopt::Long::Configure ('no_pass_through');
    require BuildPackage::Package;
    require BuildPackage::Tools;
    require BuildPackage::Allpackages;
    require SDB::Install::DebugUtilities;
    require SDB::Install::Tools;
    require SDB::Install::DirectoryWalker;
    require SDB::Install::Manifest;
    import BuildPackage::Package;
    import BuildPackage::Tools;
    import BuildPackage::Allpackages;
    import SDB::Install::DebugUtilities;
    import SDB::Install::Tools;
    import SDB::Install::DirectoryWalker;
    import SDB::Install::Manifest;
    BuildPackage::Allpackages::setMsgHandler(sub {print $_[0]});
    
    if (!GetOptions (%opt_ctrl) || $opt_help){
        my $usage = '';
        foreach my $opt (keys %opt_ctrl){
            my ($switch,$optional,$argtype) = ($opt =~ /(.*)([=:])(.*)/);
            if (defined $argtype){
                $usage .= ' [-'.$switch.' '.'<'.($argtype eq 's' ? $switch : 'number' ) .'>]'; 
            }
            else{
                $usage .= ' [-'.$opt.']'; 
            }
        }
        print "usage: buildpackage $usage\n";
        if ($opt_help){
            return 0;
        }
        exit(2);
    }
    $Vars = new BuildPackage::Vars(
        $opt_wrkdir,
        $opt_makeoutpdir,
        $opt_packdefdir,
        $opt_threads,
        $opt_makeid,
        $opt_package,
        $opt_verbose,
        $opt_kitname,
        $opt_addenv
    );
    if($Vars->{'haveXMLLib'}) {
        require XML::LibXML;
        import XML::LibXML;
    }
    my $kitPackagesSubDir = $Vars->{'GENERIC_KITSUBDIR'};
    my $threads;
    my $use_pigz;
    my $pigz;
    if($Vars->{'THREADCOUNT'} > 1) {
        import BuildPackage::Worker;
        $threads = 1;
        if ($Vars->{'HDB_STATE'} eq 'DEV' || exists $Vars->{'BP_USE_PIGZ'}){
            if (exists $Vars->{'PIGZ_BIN'} && -x "$Vars->{'PIGZ_BIN'}") {
                $pigz = "$Vars->{'PIGZ_BIN'}";
                $use_pigz = $Vars->{'THREADCOUNT'};
            } else {
                my ($path_separator,$pigz_exe,$env_separator);
                if ($^O =~ /mswin/i){
                    $path_separator = '\\';
                    $env_separator = ';';
                    $pigz_exe = 'pigz.exe';
                }
                else{
                    $path_separator = '/';
                    $env_separator = ':';
                    $pigz_exe = 'pigz';
                }
        
                foreach my $path (split($env_separator, $Vars->{'PATH'})){
                    $pigz = "$path$path_separator$pigz_exe" ;
                    if (-x $pigz){
                        $use_pigz = $Vars->{'THREADCOUNT'};
                        last;
                    }
                    $pigz = undef;;
                }
            }
    
            if (defined $pigz &&  ($pigz =~ /\s/)){
                $pigz = "\"$pigz\"";
            }
        }
    }
    BuildPackage::Allpackages::setErrMsgHandler(sub {print STDERR "ERROR: $_[0]\n"; if($threads){endWorker();} die $_[0]; });
    print "buildpackage for NewDB, version: ".$Vars->{'BUILDPACKAGE_VERSION'}."\n";
    if ($use_pigz){
        print "using pigz for compression... \n";
    }
    if($opt_verbose) {
        print "\n######### BEGIN OF ENVIRONMENT DUMP #############################\n";
        dumpThings($Vars, 3, 2);
        print "\n######### END OF ENVIRONMENT DUMP   #############################\n";
    }
    if($Vars->{'haveXMLLib'}) {
        # validate allpackages.xml against allpackages.xsd:
        eval {
            my $parser = XML::LibXML->new({
                load_ext_dtd => 0,
                expand_entities => 0,
                ext_ent_handler => sub {},
            });
            my $doc = $parser->parse_file($Vars->{'PACKDEF_MASTER_XML'});
            my $xmlschema = XML::LibXML::Schema->new('location' => $Vars->{'PACKDEF_MASTER_XML_SCHEMA'});
            $xmlschema->validate($doc);
        };
        if($@) {
            print STDERR "Could not validate \"".$Vars->{'PACKDEF_MASTER_XML'}.
                    "\"\n                   against\n                   \"".
                    $Vars->{'PACKDEF_MASTER_XML_SCHEMA'}."\".\n";
            print STDERR "Root  cause: ".$@."\n";
            exit(-1);
        }
        if($Vars->{'SDK_MODE'}) {
            # validate InstallParams.xml against installcfg.dtd:
            eval {
                my $parser = XML::LibXML->new({
                    load_ext_dtd => 0,
                    expand_entities => 0,
                    ext_ent_handler => sub {},
                });
                my $doc = $parser->parse_file($Vars->{'INSTALLPARAMS_XML_SRC'});
                my $dtdURL = URLencode($Vars->{'INSTALLCFG_DTD_SRC'});
                my $dtd = XML::LibXML::Dtd->new("SOME // Public / ID / 1.0", $dtdURL);
                $doc->validate($dtd);
            };
            if($@) {
                print STDERR "Could not validate \"".$Vars->{'INSTALLPARAMS_XML_SRC'}.
                        "\"\n                   against\n                   \"".
                        $Vars->{'INSTALLCFG_DTD_SRC'}."\".\n";
                print STDERR "Root  cause: ".$@."\n";
                exit(-1);
            }
        }
    }
    
    my $packDefs = BuildPackage::Allpackages::readXmlFile($Vars->{'PACKDEF_MASTER_XML'});
    if($Vars->{'SDK_MODE'}) {
        # separate instruntime definition (comes with the sdk) from packaging definition (maintained by sdk users)
        if(not -f $Vars->{'INSTALLER_RUNTIME_DEF'}) {
            print STDERR "Installer runtime definition \"$Vars->{'INSTALLER_RUNTIME_DEF'}\" not found.\n";
            exit(-1);
        }
        my $instruntimedef = BuildPackage::Allpackages::readXmlFile($Vars->{'INSTALLER_RUNTIME_DEF'});
        $packDefs->{'installer'} = $instruntimedef->{'installer'};
    }
    if(not defined $packDefs->{'installer'}) {
        print STDERR "Installer runtime not defined.\n";
        exit(-1);
    }
    if($opt_verbose) {
        print "\n######### BEGIN OF PACKAGE DEF DUMP #############################\n";
        dumpThings($packDefs, 7, 2);
        print "\n######### END OF PACKAGE DEF DUMP   #############################\n";
    }
    if(defined $packDefs->{'packagesDir'}) {
        $kitPackagesSubDir = $Vars->{'KITDIR'}.'/'.$packDefs->{'packagesDir'};
    }
    my @all_files;
    my @customKitFiles;
    if (ref ($packDefs->{'installer'}) eq 'HASH'){
        collectFiles($packDefs->{'installer'}->{'files'}, \@all_files, $packDefs);
        collectFiles($packDefs->{'customInstallerFiles'}, \@customKitFiles, $packDefs);
    }
    else{
        die ("no installer files definition found\n");
    }
    my %packages;
    my $deprecatedPackagesByKitSubDir = {};
    my %doppelGaengerFaenger;
    my $CLIENT_KEY = 'clientPackages';
    my $SERVER_KEY = 'serverPackages';
    $doppelGaengerFaenger{$CLIENT_KEY} = {};
    $doppelGaengerFaenger{$SERVER_KEY} = {};
    my $error_state = 0;
    my $inPackagesRef = $packDefs->{'packages'};
    my $makeroot = $Vars->{'MAKEOUTPDIR'};
    
    my $packages_pattern;
    
    
    if (defined $Vars->{'PACKAGE'}){
		$packages_pattern = '^' . join ('$|^',split(',', $Vars->{'PACKAGE'})).'$';
    }
    my $packagesRef = [];
    foreach my $pack_desc (@$inPackagesRef) {
        if (defined $Vars->{'PACKAGE'} && ($pack_desc->{'id'} !~ /$packages_pattern/)) {
            next;
        }
        if(exists $pack_desc->{'flavors'}) {
        	my $flavorsTag = $pack_desc->{'flavors'};
        	foreach my $flavorTag (@$flavorsTag) {
        		# for each flavor, make a deep copy of the pkg description:
        		my $flavor_descRef = dataDeepCopy($pack_desc);
                delete $flavor_descRef->{'flavors'};
                # the settings of the current flavor replace the resp. settings of the 
                # 'superclass' ie the pkg desc:
                my @flavorKeys = keys %$flavorTag;
                foreach my $key (@flavorKeys) {
                	my $val = $flavorTag->{$key};
                	$flavor_descRef->{$key} = $val;
                }
        		push(@$packagesRef, $flavor_descRef);
        	}
        }
        else {
        	push(@$packagesRef, $pack_desc);
        }
    }
    
    my $manifestSrcPath = undef;
    my $manifestTgtPath = undef;
    if($Vars->{'SDK_MODE'}) {
        # if we pack a generic installation, we have to copy the manifest from
        # the gen directory to the kit subdirectory 'packages':
        $manifestSrcPath = $packDefs->{'componentManifestPath'};
        $manifestTgtPath = $kitPackagesSubDir.'/manifest';
        my $compversionManifestKey = "compversion-id";
        if(not defined $manifestSrcPath) {
            # if no <componentManifestPath> tag was found in allpackages.xml, we fall back to the old (bad) behavior, for compatibility: 
            foreach my $packDesc (@$packagesRef) {
                $manifestSrcPath = $packDesc->{'softwareVersion'}->{'byManifest'}->{'manifestSrcPath'};
                if(defined $manifestSrcPath) {
                    last;
                }
            }
        }
        if(defined $manifestSrcPath) {
            $manifestSrcPath = $Vars->{'MAKEOUTPDIR'}.'/'.$manifestSrcPath;
            if(not -f $manifestSrcPath) {
                die("Could not access manifest '$manifestSrcPath' : $!\n");
            }
        }
        else {
            die("Manifest not specified in packaging description\n");
        }

        my $mf = new SDB::Install::Manifest($manifestSrcPath);
        if(not defined $mf) {
            die("Could not read manifest '$manifestSrcPath' : $!\n");
        }
        my $compVersionId = $mf->getValue($compversionManifestKey);
        if(!defined $compVersionId) {
            die("Key '$compversionManifestKey' not found in manifest '$manifestSrcPath'.\n");
        }
        if($compVersionId =~ /^0+$/) {
            die("All-zero value for key '$compversionManifestKey' in manifest '$manifestSrcPath'.\nPlease supply the component-id which is assigned to your component.\n");
        }
    }
    

    my $packageIdx = 0;
    my @ms_office_packages;
    foreach my $packDesc (@$packagesRef) {
        if (defined $Vars->{'PACKAGE'} && ($packDesc->{'id'} !~ /$packages_pattern/)) {
            next;
        }
        my $flavor = '';
        if ($packDesc->{type} eq 'flavor' && $packDesc->{kitSubDir}){
            $flavor = ' for ' . $packDesc->{kitSubDir};
        }
        my $packageCaption = $packDesc->{'name'}. "$flavor (id = " .$packDesc->{'id'}. ")";
        print "Checking package ".$packageCaption. "...\n";
        my $package = new BuildPackage::Package($packDesc, $threads, $use_pigz, $pigz, $Vars, $packDefs->{'componentManifestPath'});
        if (defined $package->{'last_error'}) {
            print STDERR "Checking package $packageCaption FAILED: ".$package->{'last_error'}. "\n";
            $error_state = 1;
            next;
        }
        # A package may be tagged as deprecated in packages.xml.
        # Such a package will be uninstalled when it is encountered 
        # on upgrade:
        if(DecodeBoolTag($package->{'DEPRECATED'})) {
            print "    This package is DEPRECATED, will not be packed,\n".
                  "    and previously installed remains will be removed on update.\n"; 
            $deprecatedPackagesByKitSubDir->{$package->{'kitSubDir'}}->{$package->{'id'}} = $package;
        }
        else {
            $packages{$packageIdx++} = $package;
            my $packageFiles = $package->{'files'};
            foreach my $fileKey (keys %$packageFiles) {
                my $file = $package->{'files'}->{$fileKey};
                my $filepath = $file->{'path'};
                my $srcFilepath = $filepath;
                if(exists $file->{'srcPath'} && defined $file->{'srcPath'}) {
                    $srcFilepath = $file->{'srcPath'};
                }
                $srcFilepath = $makeroot.'/'.$srcFilepath;
                $srcFilepath =~ s/\\/\//g;
                if($^O =~ /mswin/i) {
                    $srcFilepath = lc $srcFilepath;
                }    
                if(DecodeBoolTag($file->{'isDirectory'})) {
                    next;
                }
                if(DecodeBoolTag($file->{'systemLibrary'})) {
                    $filepath = "<systemLibrary>/$filepath";
                }
                if(DecodeBoolTag($file->{'dataFile'})) {
                    $filepath = "<dataFile>/$filepath";
                }
                if(DecodeBoolTag($package->{'isGlobal'})) {
                    $filepath = "<global>/$filepath";
                }
                my $clientOrServerKey = $SERVER_KEY;
                if(DecodeBoolTag($package->{'isClientPackage'})) {
                    $clientOrServerKey = $CLIENT_KEY;
                }
                if(exists $doppelGaengerFaenger{$clientOrServerKey}->{$filepath} &&
                   !DecodeBoolTag($package->{'retainSharedFiles'}) ) {
                    if(!DecodeBoolTag($package->{'suppressSharedFileCheck'})) {
                        print STDERR 'ERROR: package ' . $package->asString() . " shares file $filepath with package ". $doppelGaengerFaenger{$clientOrServerKey}->{$filepath} . "\n";
                        $doppelGaengerFaenger{$clientOrServerKey}->{$filepath} .= ' and package ' . $package->{'id'};
                        $error_state = 1;
                    }
                    else{
                        print 'INFO: Package ' . $package->asString() . " shares file $filepath with package ". $doppelGaengerFaenger{$clientOrServerKey}->{$filepath} . "\n";
                        print "         => Removing file '$filepath' from 'package ". $package->asString(). "\n";
                        delete $packageFiles->{$fileKey};
                    }
                }
                elsif (!DecodeBoolTag($package->{'retainSharedFiles'})){
                        $doppelGaengerFaenger{$clientOrServerKey}->{$filepath} = $package->{'id'};
                }
            }
        }
    }
    if ($error_state){
        if ($threads){
            endWorker ();
        }
        exit (1);
    }
    
    my $kitdirectory = $Vars->{'KITDIR'};
    
    if(-d $kitdirectory) {
		if ($threads){
			my $del = $kitdirectory . '_tmp';
			
			if (-e $del){
				require BuildPackage::Tools;
				BuildPackage::Tools::setErrMsgHandler(sub {print STDERR "ERROR: $_[0]\n"});
				BuildPackage::Tools::setMsgHandler(sub {print "$_[0]\n"});
				BuildPackage::Tools::deltree ($del);
			}

			if (!rename ($kitdirectory, $del)){
				print STDERR "Cannot rename old kit directory '$kitdirectory': $!\n";
				require BuildPackage::Tools;
				BuildPackage::Tools::setErrMsgHandler(sub {print STDERR "ERROR: $_[0]\n"});
				BuildPackage::Tools::setMsgHandler(sub {print "$_[0]\n"});
				BuildPackage::Tools::deltree ($kitdirectory,1);
			}
			else{
				pushTask ([2,$del]);
			}
			
		}
		else{
			require BuildPackage::Tools;
			BuildPackage::Tools::setErrMsgHandler(sub {print STDERR "ERROR: $_[0]\n"});
			BuildPackage::Tools::setMsgHandler(sub {print "$_[0]\n"});
			BuildPackage::Tools::deltree ($kitdirectory);
		}
    }
    
    if (!-d $kitdirectory){
         makedir($kitdirectory,0775) or die("cannot create HDB temporary Kit directory at $kitdirectory\n");
    }
    
    my $subDirFiles = {};
    if ($^O =~ /aix/i){
       umask(022);
    }
    foreach my $package (values %packages){
        print "creating package ".$package->asString()."...\t(".$package->GetFormattedSize.")\n";
        if ($package->{'kitSubDir'} eq 'excel')  {
            push @ms_office_packages, "$package->{'kitSubDir'}" . '\\' . $package->{archive};
        }
        unless ($package->CreatePackage ()){
            print STDERR 'cannot create package '.$package->asString().' : '.$package->{'last_error'}. "\n";
            if ($threads){
                endWorker ();
            }
            exit (3);
        }
        if(exists $package->{'kitSubDir'} && 
           defined $package->{'kitSubDir'} && 
           $package->{'kitSubDir'} !~ /^\s*$/) {
            my $dirName = $package->{'kitSubDir'};
            if(not defined $subDirFiles->{$dirName}) {
                $subDirFiles->{$dirName} = [];
            }
            push @{$subDirFiles->{$dirName}}, $package->getKitFiles();
        }
        else {
            push @all_files, $package->getKitFiles();
        }
    }
    if ($threads){
        my $errors = waitForTasks ();
        endWorker ();
        if ($errors > 0){
            print STDERR "there are tar errors\n";
            exit (4);
        }
    }
    foreach my $package (values %packages){
        $package->deleteStripDir();
    }
    
    if($Vars->{'SDK_MODE'}) {
        if(not -d $kitPackagesSubDir) {
            if(not makedir($kitPackagesSubDir,0775)) {
                die("Could not create kit subdirectory '$kitPackagesSubDir' : $!\n");
            }
        }
        if(-f $manifestSrcPath) {
            if(!copy($manifestSrcPath, $manifestTgtPath, {'binmode' => 1})) {
                die("Could not copy '$manifestSrcPath' to '$manifestTgtPath': $!\n");
            }

        }
        else {
            die("Could not access manifest '$manifestSrcPath' : $!\n");
        }
    }
    
    my $srcSlash = '\\';
    my $tgtSlash = '/';
    if($^O =~ /win32/i) {
        $srcSlash = '/';
        $tgtSlash = '\\';
    }
    my $srcdir = $Vars->{'STAGEDIR'};
    $srcdir  =~ s/\Q$srcSlash\E/$tgtSlash/go;
    my $localKitDirectory = $Vars->{'KITDIR'};
    $localKitDirectory  =~ s/\Q$srcSlash\E/$tgtSlash/go;
    my $gendir = $Vars->{'MAKEOUTPDIR'};
    $gendir  =~ s/\Q$srcSlash\E/$tgtSlash/go;
    	
    print "############ localKitDirectory=$localKitDirectory\n";
    #############################################################################
    foreach my $file (@all_files){
    	my $srcPath = $file->{'path'};
    	if(exists $file->{'srcPath'}) {
    		$srcPath = $file->{'srcPath'};
    	}
        my $fullSrcFile = $srcdir.$tgtSlash.$srcPath;
        # look also in subdir named lib, take file from there, if existent:
        my $altFullSrcFile = $Vars->{'STAGELIBDIR'}.$tgtSlash.$srcPath;
        $altFullSrcFile  =~ s/\Q$srcSlash\E/$tgtSlash/go;
        if(-f $altFullSrcFile) {
            $fullSrcFile = $altFullSrcFile;
        }
        if(exists $file->{'srcPathTemplate'}) {
            $fullSrcFile = $file->{'srcPathTemplate'};
        }
        if(-f $fullSrcFile) {
            my $fullTgtFile;
            if(defined $file->{'packagesDirPath'}) {
                $fullTgtFile = $kitPackagesSubDir.$tgtSlash.$file->{'packagesDirPath'};
            }
            else {
                $fullTgtFile = $localKitDirectory.$tgtSlash.$file->{'path'};
            }
            if (-f $fullTgtFile){
                next;
            }
            my $fullTgtDir = $fullTgtFile;
            $fullTgtDir =~ s/^(.*)(\\|\/).+/$1$2/;
            if(not -d $fullTgtDir) {
                makedir($fullTgtDir,0775) or die("cannot create kit subdirectory $fullTgtDir\n");
            }
            print "$fullSrcFile -> $fullTgtFile\n";
            copy($fullSrcFile, $fullTgtFile, {'binmode' => 1}) || die("cannot copy: $!");
        }
        else {
            die("file  $fullSrcFile does not exist.\n");
        }
    }
    foreach my $file (@customKitFiles){
    	my $srcPath = $file->{'path'};
    	if(exists $file->{'srcPath'}) {
    		$srcPath = $file->{'srcPath'};
    	}
        my $fullSrcFile = $gendir.$tgtSlash.$srcPath;
        if(-f $fullSrcFile) {
            my $fullTgtFile;
            if(defined $file->{'packagesDirPath'}) {
                $fullTgtFile = $kitPackagesSubDir.$tgtSlash.$file->{'packagesDirPath'};
            }
            else {
                $fullTgtFile = $localKitDirectory.$tgtSlash.$file->{'path'};
            }
            my $fullTgtDir = $fullTgtFile;
            $fullTgtDir =~ s/^(.*)(\\|\/).+/$1$2/;
            if(not -d $fullTgtDir) {
                makedir($fullTgtDir,0775) or die("cannot create kit subdirectory $fullTgtDir\n");
            }
            print "$fullSrcFile -> $fullTgtFile\n";
            copy($fullSrcFile, $fullTgtFile, {'binmode' => 1}) || die("cannot copy: $!");
        }
        else {
            die("file  $fullSrcFile does not exist.\n");
        }
    }
    foreach my $subDir (keys %$subDirFiles) {
        my $files = $subDirFiles->{$subDir};
        my $fullSubDir = $localKitDirectory.$tgtSlash.$subDir;
        if(scalar @$files > 0) {
            -d $fullSubDir or (makedir($fullSubDir,0775) or die("cannot create kit subdirectory $fullSubDir\n"));
            foreach my $file (@$files){
                my $srcPath = $file->{'path'};
                if(exists $file->{'srcPath'}) {
                    $srcPath = $file->{'srcPath'};
                }
                my $fullSrcFile = $Vars->{'MAKEOUTPDIR'}.$tgtSlash.$srcPath;
                if(-f $fullSrcFile) {
                    my $fullTgtFile = $fullSubDir.$tgtSlash.$file->{'path'};
                    if (-f $fullTgtFile){
                        next;
                    }
                    my $fullTgtDir = $fullTgtFile;
                    $fullTgtDir =~ s/^(.*)(\\|\/).+/$1$2/;
                    if(not -d $fullTgtDir) {
                    	makedir($fullTgtDir,0775) or die("cannot create kit subdirectory $fullTgtDir\n");
                    }
                    print "$fullSrcFile --> $fullTgtFile\n";
                    copy($fullSrcFile, $fullTgtFile, {'binmode' => 1}) || die("cannot copy: $!");
                }
                else {
                    die("missing file: $fullSrcFile\n");
                }
            }
        }
    }

    if (($^O =~ /mswin/i) && @ms_office_packages){

        my $officeinstaller_dir = $localKitDirectory.$tgtSlash.'excel';
        if (!-d $officeinstaller_dir){
            if (!mkdir ($officeinstaller_dir)){
                print STDERR "cannot create directory '$officeinstaller_dir': $!\n";
                exit 4;
            }
        }

        # copy c runtime dll into instruntime directory
        foreach my $file (@all_files){
            if ($file->{path} =~ /.*vcr.*\.dll/){
                copy ($localKitDirectory .'/'.$file->{path} ,$localKitDirectory .'/instruntime', {'binmode' => 1}) || die("cannot copy: $!");
                last;
            }
        }

        my @files = @ms_office_packages;
        push @files, grep {/excel.*manifest$|excel.*vcredist.*\.exe$|^msv.*\.dll$|^vcr.*\.dll$|^hdbsetup\.exe$/} find ('', 'f', $localKitDirectory);
        push @files, find ('instruntime', 'f', $localKitDirectory);

        #$archive,$extractor,$source_tree,@files
        my $mode = '64bit';
        if (!defined $Vars->{'WINBIT64'} || $Vars->{'WINBIT64'} =~ /false/i){
            $mode = '32bit';
        }
        my $extractorExecutable = "$srcdir/extractor.exe";
        if($Vars->{'SDK_MODE'}) {
            $extractorExecutable = $Vars->{'STAGELIBDIR'}."/extractor.exe";
        }
        if(not -f $extractorExecutable) {
            print STDERR "could not find '$extractorExecutable'.\n";
            exit 4;
        }
        print "Creating  self-extracting package '$officeinstaller_dir/SAP_HANA_client_package_for_MS_Excel.exe'...\n";
        pack_selfextracting_archive ("$officeinstaller_dir/SAP_HANA_client_package_for_MS_Excel.exe", $extractorExecutable, $localKitDirectory, @files);
    }




    # if we have deprecated packages in an installation variant (like server, client, lm, studio),
    # we write a file named 'deprecatedPackages.txt' into the corresponding kit subdirectory
    # which contains the ids of these packages. If the installer encounters one of these
    # while updating/upgrading an installation, it removes them:
    my @kitSubDirs = keys %$deprecatedPackagesByKitSubDir;
    foreach my $kitSubDir (@kitSubDirs) {
        my $deprecatedPackages = $deprecatedPackagesByKitSubDir->{$kitSubDir};
        my @deprecatedPackageIds = keys %$deprecatedPackages;
        if(scalar @deprecatedPackageIds > 0) {
            my $deprecatedPackagesListFileName = $kitdirectory.'/'.$kitSubDir.'/deprecatedPackages.txt';
            if(!open (DP,'>'.$deprecatedPackagesListFileName)){
                print STDERR  "could not create $deprecatedPackagesListFileName file: ".$!."\n";
                exit(5);
            }
            my $header = "# The following packages existed in previous releases\n".
                         "# and are deprecated now. Remains of these in an installation\n".
                         "# will be removed on upgrade.\n";
            print DP $header;
            foreach my $deprecatedPackageId (@deprecatedPackageIds) {
                print DP "$deprecatedPackageId\n";
            }
            close DP;
        }
    }
    
    # if we pack a generic installation, we have to copy the prepackaged package archives from
    # the sdk/lib directory (it's only present there in the generic case)
    # to the kit subdirectory 'packages':
    if(defined $packDefs->{'SDKprePackagedArchives'}) {
        my $SDKprePackagedArchivesRef = $packDefs->{'SDKprePackagedArchives'};
        foreach my $archive (@$SDKprePackagedArchivesRef) {
            my $archiveSrcPath = $Vars->{'STAGELIBDIR'}.'/'.$archive;
            my $archiveLstSrcPath = $archiveSrcPath.'.lst';
            my $archiveTgtPath = $kitPackagesSubDir.'/'.$archive;
            my $archiveLstTgtPath = $archiveTgtPath.'.lst';
            print "$archiveSrcPath -> $archiveTgtPath \n";
            if(-f $archiveSrcPath && -d $kitPackagesSubDir) {
                copy($archiveSrcPath, $archiveTgtPath, {'binmode' => 1}) || die("cannot copy: $!");
            }
            print "$archiveLstSrcPath -> $archiveLstTgtPath \n";
            if(-f $archiveLstSrcPath && -d $kitPackagesSubDir) {
                copy($archiveLstSrcPath, $archiveLstTgtPath, {'binmode' => 1}) || die("cannot copy: $!");
            }
        }
    }
    
    if($Vars->{'SDK_MODE'}) {
        # if we pack a generic installation, we have to copy 'InstallParams.xml' from
        # the packdef directory (it's only present there in the generic case)
        # to the kit subdirectory 'packages':
        if(-f $Vars->{'INSTALLPARAMS_XML_SRC'}) {
            copy($Vars->{'INSTALLPARAMS_XML_SRC'}, $kitPackagesSubDir.'/'.$Vars->{'INSTALLPARAMS_XML'}, {'binmode' => 1}) || die("cannot copy: $!");
        }
        else {
            die("Missing file: $Vars->{'INSTALLPARAMS_XML_SRC'}");
        }
        # we also have to copy 'installcfg.dtd'
        # to the kit subdirectory 'packages':
        if(-f $Vars->{'INSTALLCFG_DTD_SRC'}) {
            copy($Vars->{'INSTALLCFG_DTD_SRC'}, $kitPackagesSubDir.'/'.$Vars->{'INSTALLCFG_DTD'}, {'binmode' => 1}) || die("cannot copy: $!");
        }
        else {
            die("Missing file: $Vars->{'INSTALLCFG_DTD_SRC'}");
        }
        # we also have to copy the CustomModules folder
        # to the kit subdirectory 'packages':
        if(-d $Vars->{'CUSTOMMODULES_SRCDIR'}) {
                my $tgtDir = $kitPackagesSubDir.'/'.$Vars->{'CUSTOMMODULES_DIR'};
                print "processing custom modules from $Vars->{'CUSTOMMODULES_SRCDIR'} :\n";
                if(not -d $tgtDir) {
                    if(not makedir($tgtDir, 0775)) {
                        die("cannot create folder $tgtDir");
                    }
                }
                ###### begin of SDB::Install::DirectoryWalker exemplary ctor call ######
                my $dirWalker = SDB::Install::DirectoryWalker->new(
                    undef, # no actionMatcher callback set, i.e. we process everything we encounter
                    undef, # actionMatcher is not set.
                    undef, # actionMatcher is not set.
                    undef, # no pruneMatcher callback set...
                    undef, # ...hence no pruneMatcherObj
                    undef, # ...and no pruneMatcher user data
                    sub{   # action callback
                        my $isDir = $_[6];
                        my $fullTgt = $tgtDir.$tgtSlash.$_[4];
                        if($isDir) { 
                            print "creating dir $fullTgt\n";
                            return makedir($fullTgt, 0775);
                        }
                        else {
                            my $fullSrc = $_[3].$tgtSlash.$_[4];
                            print "$fullSrc ---> $fullTgt\n";
                            return copy($fullSrc, $fullTgt, {'binmode' => 1});
                        }
                    },
                    undef, # action is a function.
                    undef, # no user data
                    1,     # do it breadth-first, to create directories before copying their content.
                    1,     # dont collect list
                    1      # follow symlinks
                    
                );
                ######   end of SDB::Install::DirectoryWalker exemplary ctor call ######
                ###### begin of SDB::Install::DirectoryWalker::findAndProcess exemplary call ######
                my $rc = $dirWalker->findAndProcess($Vars->{'CUSTOMMODULES_SRCDIR'});
                if(not defined $rc) {
                    die($dirWalker->getErrorString());
                }
                ######   end of SDB::Install::DirectoryWalker::findAndProcess exemplary call ######
        }
    }
    return 0;
    
} # end of sub main.


#-----------------------------------------------------------------------------

sub start;
*start = \&main;

#-----------------------------------------------------------------------------

sub collectFiles {
    my (
        $files,
        $collector,
        $packDefs
    ) = @_;
    foreach my $file (@{$files}){
        if(DecodeBoolTag($file->{'installerGui'}) && !DecodeBoolTag($packDefs->{'installerGui'})) {
            next;
        }
        if($file->{'type'} eq 'subTree') {
            my $srcSlash = '\\'; # any defined value would do here.
            my $tgtSlash = '/';
            if($^O =~ /win32/i) {
                $srcSlash = '/';
                $tgtSlash = '\\';
            }
            my $numberOfFoundFiles = 0;
            ###### begin of SDB::Install::DirectoryWalker exemplary ctor call ######
            my $dirWalker = SDB::Install::DirectoryWalker->new(
            
                sub{   # actionMatcher callback, see comments in DirectoryWalker.pm for full signature
                    my $relentry = $_[4]; # path of the file/dir in process, relative to $root
                    my $isDir = $_[6];    # 1 iff true, '' iff no dir, undef iff inexistent or error
                    if($isDir) {
                        return 0;
                    }
                    my $include = 1;
                    my $exclude = 0;
                    if(defined $file->{'includeFileNamePattern'}) {
                        $include = 0;
                        if($relentry =~ /$file->{'includeFileNamePattern'}/) {
                            $include = 1;
                        }
                    }
                    if(defined $file->{'excludeFileNamePattern'} && $relentry =~ /$file->{'excludeFileNamePattern'}/) {
                        $exclude = 1;
                    }
                    if($include && not $exclude) {
                        return 1;
                    }
                    return 0;
                },
                undef, # actionMatcher is a function, not a method which would require an object to call it on here.
                undef, # we dont have to pass a ref to user defined data to the actionMatcher since we can use 
                       # "lexical closure" (well, sort of) here which perl seems to support. See $file above.
                       
                undef, # no pruneMatcher callback set...
                undef, # ...hence no pruneMatcherObj
                undef, # ...and no pruneMatcher user data
                
                sub{   # action callback, see comments in DirectoryWalker.pm for full signature
                    my $relentry = $_[4]; # path of the file/dir in process, relative to $root
                    my $singlefile = {};
                    $singlefile->{'path'} = $file->{'path'}.$tgtSlash.$relentry;
                    if(defined $file->{'srcPath'}) {
                        $singlefile->{'srcPath'} = $file->{'srcPath'}.$tgtSlash.$relentry;
                    }
                    if(defined $file->{'srcPathTemplate'}) {
                        $singlefile->{'srcPathTemplate'} = $file->{'srcPathTemplate'}.$tgtSlash.$relentry;
                    }
                    if(defined $file->{'permissions'}) {
                        $singlefile->{'permissions'} = $file->{'permissions'};
                    }
                    push @{$collector}, $singlefile;
                    $numberOfFoundFiles++;
                    return 1;
                },
                undef, # no object to call action on
                undef, # no user defined data, since we can use closure here, cf @all_files, $file.
                
                0,     # no breadth-first traversal, so we do it depth-first.
                1,    # dont collect list
                1     # follow symlinks
                
            );
            ######   end of SDB::Install::DirectoryWalker exemplary ctor call ######
            my $subTreeRoot = $file->{'path'};
            if(defined $file->{'srcPath'}) {
                $subTreeRoot = $file->{'srcPath'};
            }
            # look also in subdir named lib, take file from there, if existent:
            my $altSubTreeRoot = $Vars->{'STAGELIBDIR'}.$tgtSlash.$subTreeRoot;
            $subTreeRoot = $Vars->{'STAGEDIR'}.$tgtSlash.$subTreeRoot;
            if(-d $altSubTreeRoot) {
                $subTreeRoot = $altSubTreeRoot;
            }
            if(defined $file->{'srcPathTemplate'}) {
                $subTreeRoot = $file->{'srcPathTemplate'};
            }
            $subTreeRoot  =~ s/\Q$srcSlash\E/$tgtSlash/go;
            ###### begin of SDB::Install::DirectoryWalker::findAndProcess exemplary call ######
            my $rc = $dirWalker->findAndProcess($subTreeRoot);
            if(not $rc) {
                # $dirWalker->findAndProcess terminates traversal on first internal error (by returning undef),
                # so we have to retrieve only this single error ($dirWalker is a SDB::Install::Base):
                die($dirWalker->getErrorString());
            }
            ######   end of SDB::Install::DirectoryWalker::findAndProcess exemplary call ######
            if($numberOfFoundFiles == 0) {
                print STDERR "WARNING:  empty directory $subTreeRoot referenced by subTree tag.\n";
            }
        }
        else {
            push @{$collector}, $file;
        }
    }
    return 1;
}

#-----------------------------------------------------------------------------

1;
