package LCM::ActionsDetector::Action::AddHosts;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';
use LCM::HostsUtility;
use SDB::Install::Globals qw($gFlavourPlatform);


sub requiresExistingInstance {
    return 0;
}

sub getSupportedFlavours {
    return [ $gFlavourPlatform ];
}

sub getKey {
    my ($self) = @_;
    return 'AddHosts';
}

sub getBatchKey {
    my ($self) = @_;
    return 'add_hosts';
}

sub getUIString {
    my ($self) = @_;
    return sprintf("Add Hosts to the %s System", $self->_getProductName());
}

sub requiresRoot {
    my ($self) = @_;
    return !LCM::HostsUtility::IsHostPartOfSystem();
}

1;