package LCM::ActionsDetector::Action::ConfigureInternalNetwork;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';
use SDB::Install::Globals qw($gFlavourPlatform);


sub getSupportedFlavours {
    return [ $gFlavourPlatform ];
}

sub getKey {
    my ($self) = @_;
    return 'ConfigureInternalNetwork';
}

sub getBatchKey {
    my ($self) = @_;
    return 'configure_internal_network';
}

sub getUIString {
    my ($self) = @_;
    return "Configure Inter-Service Communication";
}

sub requiresExistingInstance {
    my ($self, $actionsManager) = @_;
    my $config = $actionsManager->getConfiguration();
    if($config->isScopeInstance("hdblcm_configure_internal_network")) {
        return 0;
    }
    return 1;
}

1;