package LCM::ActionsDetector::Action::RenameSystem;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';


sub getKey {
    my ($self) = @_;
    return 'RenameSystem';
}

sub getBatchKey {
    my ($self) = @_;
    return 'rename_system';
}

sub getUIString {
    my ($self) = @_;
    return sprintf("Rename the %s System", $self->_getProductName());
}

sub requiresRoot {
    return 1;
}

sub requiresExistingInstance {
    my ($self, $actionsManager) = @_;
    my $config = $actionsManager->getConfiguration();
    if($config->isScopeInstance("hdblcm_rename_system")) {
        return 0;
    }
    return 1;
}

1;