package LCM::ActionsDetector::Action::Uninstall;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';
use LCM::Installer;


sub getKey {
    my ($self) = @_;
    return 'Uninstall';
}

sub getBatchKey {
    my ($self) = @_;
    return 'uninstall';
}

sub getUIString {
    my ($self) = @_;
    return sprintf("Uninstall %s Components", $self->_getProductName());
}

sub requiresRoot {
    my ($self) = @_;
    return !$self->_hasUninstallableComponents();
}

sub _hasUninstallableComponents {
    my ($self) = @_;
    my $scm = LCM::Installer->new()->getOwnSystemComponentManager();
    return $scm ? $scm->hasUninstallableComponents() : 0;
}

1;