package LCM::ActionsDetector::Action::UnregisterInstance;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';


sub getKey {
    my ($self) = @_;
    return 'UnregisterInstance';
}

sub getBatchKey {
    my ($self) = @_;
    return 'unregister_instance';
}

sub getUIString {
    my ($self) = @_;
    return sprintf("Unregister the %s Instance", $self->_getProductName());
}

sub requiresRoot {
    return 1;
}

sub executeSpecificChecks {
    my ($self, $actionsManager) = @_;
    if ($actionsManager->getNumberOfHosts() < 2) {
        $self->_setNotApplicableReason('this is a single-host system');
        return 0;
    }
    return 1;
}

1;