package LCM::ActionsDetector::Action::Update;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';


sub new {
    my ($class, $pendingInfo) = @_;
    my $self = $class->SUPER::new();
    $self->{pendingInfo} = $pendingInfo;
    return $self;
}

sub getKey {
    my ($self) = @_;
    return 'Update';
}

sub getBatchKey {
    my ($self) = @_;
    return 'update';
}

sub getUIString {
    my ($self) = @_;
    my $pendingInfo = $self->getPendingInfo();
    return sprintf("Update the %s System%s", $self->_getProductName(), $pendingInfo);
}

sub getPendingInfo {
    my ($self) = @_;
    return $self->{pendingInfo} // '';
}

1;