package LCM::App::CLIArgumentsParser;

use strict;
use parent 'SDB::Install::Base';

sub new {
    my ($class, $app) = (shift(), shift());
    my $self = $class->SUPER::new(@_);
    $self->setApp($app);

    return $self;
}

sub setApp {
    my ($self, $app) = @_;
    $self->{application} = $app;
}

sub getApp {
    my ($self) = @_;
    return $self->{application};
}

sub getLeftoverArguments {
    my ($self) = @_;
    return $self->{leftOverCmdLineArgs} // [];
}

sub parse {
    my ($self, $isPassThrough) = @_;
    my $app = $self->getApp();

    if (!defined $self->{leftOverCmdLineArgs}){
        $self->{leftOverCmdLineArgs} = [@{$app->{cmdLineArgsAfterInit}}];
    }
    $self->{leftOverCmdLineArgs} = $app->ParseConfigCmdLineArgs( $self->{leftOverCmdLineArgs}, $isPassThrough);
    return (defined $self->{leftOverCmdLineArgs}) ? 1 : undef;
}

1;