package LCM::Component::Installable::HDBClient::HDBClientBase;

use SDB::Install::Globals qw($gProductNameClient);
use SDB::Install::Configuration::Client;
use LCM::Configuration::GenericStackAny qw ($ini_section_client);
use LCM::HDBComponentsConfigurator qw($action_register $action_unregister);
use LCM::Component::Registrable qw($RETURN_CODE_SUCCESS $RETURN_CODE_ERROR);
use strict;

use base 'LCM::Component::Installable','LCM::Component::Registrable';

sub getNumberOfExpectedOutputLines{
    return 31;
}

sub _buildArgs {
	my ($self, $instconfig) = @_;

    my $clientConfig = $self->getExternalHdbInstallerConfiguration();
    return undef if (!defined $clientConfig);

	my $args = $instconfig->getCmdLineArgsFromInstconfig (
            $clientConfig,['Target'], $ini_section_client);
	my $path = $self->getClientPath($instconfig);
	push @$args, '--path='. $path;
	push @$args, "--archive_dir=$self->{manifestDir}";
	push @$args, @{$self->SUPER::_buildArgs($instconfig)};
	return $args;
}

sub getClientPath {
	my ($self, $instconfig) = @_;
	
	my $path;
    my $installedComponent = $self->getInstalledComponent();
    if (defined $installedComponent){
        $path = $installedComponent->getPath ();
    }
    else{
        $path = $instconfig->getValue ('ClientPath');
    }
    
    return $path;
}

sub getComponentName {
    return $gProductNameClient;
}

sub register{
    my($self,$logger,$instconfig,$sharedDir,$sid) = @_;
    if(!defined $logger){
    	$logger = $self;
    }
    my $componentName = $self->getComponentName();

    my $rc = $self->configureHdbComponents ($logger,['hdbclient'],
        $sharedDir, $sid, $action_register);
    
    if(!defined $rc){
        return $RETURN_CODE_ERROR;
    }
    else{
        return $RETURN_CODE_SUCCESS;
    }
}

sub getSlppLogFileName {
	return 'client.log'
}

sub getFallbackHdbInstallerConfiguration {
    return SDB::Install::Configuration::Client->new();
}

sub isSigned {
    return 1;
}

sub requiresRootPrivilege {
    return 1;
}

1;
