package LCM::Component::Installable::HDBServer::HDBServerSidAdm;

use LCM::Component;
use LCM::Component::Installable::HDBServer::HDBServerBase;
use SDB::Install::Globals qw($gLogDir determineSignedManifestContainingDirectory $gProductNameEngine);

use strict;
use base 'LCM::Component::Installable::HDBServer::HDBServerBase';

my $DU_IMPORT_WARNING = "'$gProductNameEngine' update finished with warning, because of\nfailed deployment of HANA content (part of '$gProductNameEngine' archive).\nFor next steps, check SAP Note 1795885.";

sub installComponent {
	$_[0]->setErrorMessage ("installComponent with sidadm user is not implemented");
	return undef;
}

sub updateComponent {
	my ( $self, $instconfig ) = @_;
	my $msg = $self->getMsgLst ()->addProgressMessage ($self->getProgressMsg() . '...');
	my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
	my $operation = 'HdbServerUpdate_v11';
	my $manifestDir = determineSignedManifestContainingDirectory($self->getInstallerDir());
	my $args = $self->_buildArgs($instconfig);
	my $optionMap = {
		'SERVER_CMP_PATH' => $self->getInstallerDir(),
		'MANIFEST_PATH'   => $manifestDir,
	};

	$optionMap = $self->buildSHAOptionsMap($instconfig, $optionMap, $args, 1);
	my $passwordKeys = ['Password', 'HostagentPassword','SQLSysPasswd', 'RootPassword'];

	$self->initProgressHandler ();

	my $rc = $self->installThroughSHAOperation($instconfig, $operation, $optionMap, $passwordKeys, 1);

	$msg->endMessage (undef, "Updating " . $self->getComponentName());
	$self->setMsgLstContext($saveCntxt);

	return $rc;
}

sub _hasError {
	my ($self, $returnCode) = @_;

	if ($self->isUpdate() && $returnCode == 2) { # DU Import has failed, treat this as a warning
		$self->getMsgLst()->addWarning("Problems occurred while importing delivery units (content)");
		LCM::ExecutionWarningsObservable->getInstance()->notifyWarning($DU_IMPORT_WARNING);
		return 0;
	}
	return $self->SUPER::_hasError($returnCode);
}

sub updateSHAOptionsMap {
	my ($self, $optionMap, $newInstallationKitPath) = @_;
	$optionMap->{SERVER_CMP_PATH} = $newInstallationKitPath;
	$optionMap->{MANIFEST_PATH} = $newInstallationKitPath;
	$optionMap->{ARCHIVE_DIR} = $self->getPath();
}

sub getFilelistFileName {
	return 'filelist.update';
}

sub getCopyInstallerOperation {
	return 'HdbCopyServerInstaller_v7';
}

sub getDeleteCopiedInstallerOperation {
	return 'HdbRemoveCopiedServerInstaller_v4';
}

sub getCopiedInstallerDirPrefix {
	return 'server_installer_kit_';
}

1;
