package LCM::Component::Installable::LSS::LSSSidAdm;

use strict;
use SDB::Install::Globals qw (determineSignedManifestContainingDirectory);

use base 'LCM::Component::Installable::LSS::LSSBase';

sub _installLSSComponent {
    my ($self, $instconfig) = @_;
    my $operation = 'HdblcmLSSInstall_v2';
    my $installerDir = $self->getInstallerDir();
    my $manifestDir = determineSignedManifestContainingDirectory($installerDir);
    my $optionMap = {
        'LSS_CMP_PATH' => $installerDir,
        'MANIFEST_PATH' => $manifestDir,
    };
    my $args = $self->_buildArgs($instconfig);
    if (!defined($args)) {
        return undef;
    }

    $optionMap = $self->buildSHAOptionsMap($instconfig, $optionMap, $args, 1);
    return $self->installThroughSHAOperation($instconfig, $operation, $optionMap, ['LSSBackupPassword', 'LSSPassword'], 1);
}

sub updateSHAOptionsMap {
    my ($self, $optionMap, $newInstallationKitPath) = @_;
    $optionMap->{LSS_CMP_PATH} = $newInstallationKitPath;
    $optionMap->{MANIFEST_PATH} = $newInstallationKitPath;
    $optionMap->{ARCHIVE_DIR} = $self->getPath();
}

sub getFilelistFileName {
    return 'filelist.installer';
}

sub getCopyInstallerOperation {
    return 'HdbCopyLSSInstaller_v1';
}

sub getDeleteCopiedInstallerOperation {
    return 'HdbRemoveCopiedLSSInstaller_v1';
}

sub getCopiedInstallerDirPrefix {
    return 'lss_installer_kit_';
}

1;
