package LCM::Component::Installable::ResidentInstaller::ResidentInstallerBase;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Persistence::XMLGenerator;
use SDB::Install::Globals qw($gDirNameResidentInstaller $gShortProductNameInstaller);
use LCM::Component qw (COMPONENT_NAME_INSTALLER OFFLINE_PHASE);
use LCM::Manifests::SAPSignature;

use strict;

use base qw(LCM::Component::InternallyPersistedInstallable);

my $PENDING_FILE_NAME = 'pending_hdblcm.xml';

sub new {
    my $self = shift->SUPER::new (@_);
    $self->selectComponent();
    return $self;
}

sub getNumberOfExpectedOutputLines{
    return 15;
}

sub getDefaultSelection{
    my ($self, $stackUpdate) = @_;

	if (!$stackUpdate) {
		return 1;
	}

	my $installedComponent = $self->getInstalledComponent();
	if (!$installedComponent) {
		return 1;
	}

	my $newVersion = new SDB::Install::Version(split('\.', $self->getVersion()));
	my $installedVersion = new SDB::Install::Version(split('\.', $installedComponent->getVersion()));
	if ($installedVersion->isNewerThan($newVersion)) {
		return 0;
	} else {
		return 1;
	}
}

sub getComponentName {
    return COMPONENT_NAME_INSTALLER;
}

sub getVerificationString {
    return "External $gShortProductNameInstaller";
}

sub isInternal{
	return 1;
}

sub getSlppLogFileName {
	return 'hdblcm.log'
}

sub getDefaultPhase {
	return OFFLINE_PHASE;
}

sub shouldVerifyFiles {
    my $self = shift;
    my @serverComponentMatch = grep { $_->isServer() } @{$self->getComponentManager()->getSelectedComponents()};
    if( scalar(@serverComponentMatch) > 0 ){
        my $serverSignature = $serverComponentMatch[0]->getSignature();
        if( defined $self->getSignature() && defined $serverSignature && $self->getSignature()->getSignatureFilePath() eq $serverSignature->getSignatureFilePath()){
            return 0;
        }
    }
    return 1;
}

sub _getInstallationPath {
    my ($self, $instconfig) = @_;
    my $instSidDir = $self->getInstSidPath($instconfig);
    return defined($instSidDir) ? File::Spec->catfile($instSidDir, $gDirNameResidentInstaller) : undef;
}

sub setIsSigned {
    my ($self, $isSigned) = @_;
    $self->{isSigned} = $isSigned // 1;
}

sub isSigned {
    my ($self) = @_;
    return $self->{isSigned} // 0;
}

1;
