package LCM::Component::Installed::AcceleratorInstalled;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Globals qw($gHostRoleAcceleratorWorker
                             $gHostRoleAcceleratorStandby
                             $gProductNameAccelerator);
use SDB::Install::LayeredConfig qw (CFG_LAYER_SYSTEM);
use SDB::Install::System qw (isAdmin);
use LCM::ProcessExecutor;
use LCM::Installer;
use strict;

use parent 'LCM::Component::Installed';

our $acceleratorUninstallExecutable = 'aseuninst' . ($isWin ? '.exe' : '.sh');

sub preCheckUninstallComponent {
    my ($self, $instconfig) = @_;
    return $self->checkComponentHostsExist($instconfig);
}

sub uninstallComponent {
    my ($self, $instconfig) = @_;
    my $rc  = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $sapSystem = $instconfig->getSAPSystem(1); # no cache

    if (!defined($sapSystem)) {
        $self->setErrorMessage(sprintf("No SAP system '%s' found", $instconfig->getValue("SID")));
        $msg->endMessage( undef, 'Uninstall ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }

    # uninstall
    $self->cleanComponentDaemonIniEntries($instconfig);
    my $processExecutor = $self->_createProcessExecutor( $instconfig, $sapSystem);

    $self->initProgressHandler();
    $processExecutor->setOutputHandler($self->getProgressHandler());

    my $exitCode = $processExecutor->executeProgram();

    $self->getMsgLst ()->addMessage(undef, $processExecutor->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($processExecutor->getOutputLines()));
    $self->_deleteGlobalIniPersistenceEntries($sapSystem);

    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($processExecutor->getOutputLines());
        $errMsgLst = $processExecutor->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    }

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub _deleteGlobalIniPersistenceEntries {
    my ($self, $sapSystem) = @_;
    my $ownInstance = $sapSystem->getNewDBInstances()->[0];
    my $globalIni = !defined($ownInstance) ? undef : $ownInstance->getGlobalIni($self->getMsgLst(), 1);
    my $saveContext = !defined($globalIni) ? undef : $globalIni->setMsgLstContext ([$self->getMsgLst()]);

    return if(!defined($globalIni));

    $globalIni->removeKey(CFG_LAYER_SYSTEM, 'persistence','basepath_datavolumes_ets');
    $globalIni->removeKey(CFG_LAYER_SYSTEM, 'persistence','basepath_logvolumes_ets');

    if(!$globalIni->write()){
        $self->getMsgLst()->AddWarning(sprintf('Failed to remove %s persistence entries from global.ini', $gProductNameAccelerator));
    }
    $globalIni->setMsgLstContext($saveContext);
}

sub getComponentName {
    return $gProductNameAccelerator;
}

sub getNumberOfExpectedOutputLines {
    return 15;
}

sub getHostRoles {
    return [$gHostRoleAcceleratorWorker, $gHostRoleAcceleratorStandby];
}

sub getSlppLogFileName {
    return 'ase.log'
}

sub _createProcessExecutor {
    my ($self, $instconfig, $sapSystem) = @_;
    my $command = join($path_separator, $sapSystem->get_globalSidDir(), 'ase', 'hdblcm', $acceleratorUninstallExecutable);
    my ($uid, $gid) = (undef, undef);

    if (isAdmin()){
        my $user = $sapSystem->getUser();
        ($uid, $gid) = ($user->uid(), $user->gid());
    }

    return new LCM::ProcessExecutor($command, undef, undef, undef, undef, $uid, $gid);
}

1;