package LCM::Component::Installed::HDBServerPlugin::HDBServerPluginSidAdm;

use strict;
use parent 'LCM::Component::Installed::HDBServerPlugin::HDBServerPluginBase';

my $UNINSTALL_OPERATION = 'HdbUninstallServerPlugin_v3';

sub uninstallComponent {
    my ( $self, $instconfig ) = @_;

    my $optionsMap = $self->_buildOptionsMap($instconfig);

    my $passwordKeys;

    foreach my $passwordParam ('Password', 'SQLSysPasswd'){
        if (!$instconfig->isSkipped($passwordParam) && $instconfig->hasValue($passwordParam)){
            if (!defined $passwordKeys){
                $passwordKeys = [];
            }
            push @$passwordKeys, $passwordParam;
        }
    }

    my $exitCode = $self->_executeThroughSHAOperation($instconfig, $UNINSTALL_OPERATION, $optionsMap, $passwordKeys, 1, 'Uninstallation');

    return $exitCode if (!defined($exitCode));

    my $manifestDirectory = $self->getPath();
    $self->removeComponentDirectory($manifestDirectory);
    return $exitCode;
}

sub _buildOptionsMap {
    my ($self, $instconfig) = @_;

    my $optionsMap = {
        SID => $instconfig->getSID(),
        PATH => $self->getPath(),
    };
    if (!$self->shouldRestartSystemPostUninstall($instconfig)) {
        $optionsMap->{NORESTART} = 1;
    }
    elsif(!$instconfig->isSkipped('SystemUser') && $instconfig->hasValue('SystemUser')){
        $optionsMap->{SYSTEM_USER} = $instconfig->getValue('SystemUser');
    }
    return $optionsMap;
}

1;