package LCM::Component::Installed::HLM;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::System qw (deltree);
use LCM::ProcessExecutor;
use LCM::HDBComponentsConfigurator qw($action_register $action_unregister);
use LCM::Component::Registrable qw($RETURN_CODE_SUCCESS $RETURN_CODE_ERROR);
use SDB::Install::Globals qw($gProductName);

use strict;

use base 'LCM::Component::Installed','LCM::Component::Registrable';

sub uninstallComponent{
    my ( $self, $instconfig ) = @_;
    my $componentName = $self->getComponentName();
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $componentName . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $errlst = new SDB::Install::MsgLst;
    my $hlmDirectory = $self->getPath();
    my $rc;

    if (!-d $hlmDirectory) {
        $self->getMsgLst()->addMessage ("$componentName cannot be uninstalled: '$hlmDirectory' does not exist");
        $rc = 0;
    } else {
        $self->getMsgLst()->addMessage ("Removing directory '$hlmDirectory'...");
        if ( ! deltree($hlmDirectory, $errlst) ) {
            $self->setErrorMessage ("Cannot uninstall $componentName", $errlst);
            $rc = 0;
        } else {
            $self->getMsgLst()->addMessage ("Directory '$hlmDirectory' was removed successfully!");
            $rc = 1;
        }
    }

    $msg->endMessage (undef, 'Uninstall ' . $componentName);
    $self->setMsgLstContext($saveCntxt);
    return 1;
}

sub getComponentName {
    return "$gProductName Lifecycle Manager";
}

sub getVersion{
	my $self = shift;
	my $version = $self->SUPER::getVersion();
	$version = $version eq "1.50.00.00.357448"? "1.00.6" : $version;
	return $version;	
}	

sub register { # TODO - check if possible to do this as sidadm
    my($self,$logger,$instconfig,$sharedDir,$sid) = @_;

    if(!defined($logger)){
        $logger = $self;
    }

    my $componentName = $self->getComponentName();
    $logger->getMsgLst()->addWarning("Registration of $componentName is no longer supported");
    return $RETURN_CODE_SUCCESS;
}

sub unregister { # TODO - check if possible to do this as sidadm
    my($self,$logger,$instconfig,$sharedDir,$sid,$remoteHosts,$skipLocalhost, $subsetRemoteHosts) = @_;

    if(!defined($logger)){
        $logger = $self;
    }

    my $componentName = $self->getComponentName();
    $logger->getMsgLst()->addWarning("Unregistration of $componentName is no longer supported");
    return $RETURN_CODE_SUCCESS;
}

1;
