package LCM::Component::Installed::SDA;

use strict;
use warnings;
use base 'LCM::Component::Installed';
use LCM::ProcessExecutor;
use SDB::Install::Globals qw(
    $gProductNameSDA
    $gProductNameEngine
);
use SDB::Install::System qw (isAdmin);
use SDB::Install::NewDBUser;
use SDB::Install::ComponentVersion;
use File::Spec;


sub uninstallComponent{
    my ($self, $configuration) = @_;
    my $cmpName = $self->getComponentName();
    my $msg = $self->getMsgLst()->addProgressMessage(sprintf("Uninstalling %s...", $cmpName));
    my $saveCtx = $self->setMsgLstContext([$msg->getSubMsgLst()]);
    my $scm = $configuration->getSystemComponentManager();
    my ($rc, $errMsgLst) = (0, undef);
    $self->initProgressHandler();

    if ($scm->isHDBServerComponentSelected()) {
        $self->getMsgLst()->addMessage("$cmpName will be uninstalled during the uninstallation of $gProductNameEngine.")
    } else {
        my $executor = $self->_createProcessExecutor($configuration);
        my $exitCode = $executor->executeProgram();
        $self->setLogLocation($self->parseLogFileLocation($executor->getOutputLines()));
        ($rc, $errMsgLst) = ($exitCode, $executor->getErrMsgLst());
    }

    $self->_handleUninstallationExitCode($rc, $configuration, $errMsgLst);

    $msg->endMessage(undef, "Uninstall $cmpName");
    $self->setMsgLstContext($saveCtx);
    return defined($rc) && !$rc;
}

sub _createProcessExecutor {
    my ($self, $configuration) = @_;
    my $installationPath = $self->getInstallationPath();
    my $uninstallScript = File::Spec->catfile($installationPath, 'uninstall.sh');
    my $sid = $configuration->getSID();
    my ($uid, $gid) = (undef, undef);
    if (SDB::Install::System::isAdmin()) {
        my $sidadmUser = SDB::Install::NewDBUser->new($sid);
        $uid = $sidadmUser->uid();
        $gid = $sidadmUser->gid();
    }
    my $executor = LCM::ProcessExecutor->new(
        $uninstallScript,   # executable
        ['-s', $sid],       # arguments
        undef,              # STDIN stream
        undef,              # CWD
        undef,              # restore CWD
        $uid,               # uid
        $gid,               # gid
    );
    $executor->setMsgLstContext($self->getMsgLstContext());
    $executor->setOutputHandler($self->getProgressHandler());
    return $executor;
}

sub getComponentName {
    return $gProductNameSDA;
}

sub getSlppLogFileName {
	return 'sda.log';
}

sub getNumberOfExpectedOutputLines {
    return 2;
}

sub canBeSelectedForUninstall {
    my ($self) = @_;
    my $versionObject = $self->getVersionObject();
    my $minUninstallationVersion = SDB::Install::ComponentVersion->new('2', '00', '4');
    return $versionObject->isNewerThan($minUninstallationVersion) || $versionObject->isEqual($minUninstallationVersion);
}

1;
