package LCM::Component::Installed::XS::XS2Root;
use parent LCM::Component::Installed::XS2;

use SDB::Install::System qw(deltree);

sub deleteXSPostUninstallData { 
    my($self,$instconfig,$sapSystem) = @_;
    my $xsDir = File::Spec->catdir(($sapSystem->get_globalSidDir(), 'xs'));

    $self->_tryDeleteXsaApplicationsPersistency($sapSystem);
    return undef if (!deltree($xsDir, $self->getMsgLst(), $self->getErrMsgLst()));
    $self->_tryDeleteXsaAppWorkingDir($instconfig);
    return 1;
}

sub _tryDeleteXsaAppWorkingDir {
    my ($self, $instconfig) = @_;
    my $instance = $instconfig->getOwnInstance();
    my $xsaAppWorkingDir = $instance->getXSEADataPath();
    if (defined $xsaAppWorkingDir && -d $xsaAppWorkingDir) {
        deltree($xsaAppWorkingDir, $self->getMsgLst(), $self->getErrMsgLst());
    }
}

sub _tryDeleteXsaApplicationsPersistency {
    my ($self, $sapSystem) = @_;
    my $globalSidDirectory = $sapSystem->get_globalSidDir() || $sapSystem->getUsrSapSid();
    my $pendingXml = File::Spec->catdir(($globalSidDirectory, 'pending_xs_components.xml'));
    return if (! -e $pendingXml);
    $self->getMsgLst()->addMessage("Deleting '$pendingXml'");
    if (!unlink($pendingXml)) {
        $self->getMsgLst()->addWarning("Failed to remove '$pendingXml': $!");
    }
}

1;