package LCM::Component::LCMsdkInstallable;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Configuration::Generic;
use SDB::Install::IniFile;
use strict;

use base 'LCM::Component::Installable';

sub isUpdate{
    my ($self) = @_;

    if(! defined $self->{_isUpdate}){
        $self->_detectIsUpdateFromLCMsdkPersistenceFile();
        if (!defined $self->{_isUpdate}){
            $self->_detectIsUpdateFromPersistenceXMLObject();
        }
    }
    return $self->{_isUpdate} // $self->SUPER::isUpdate();
}

sub getLCMsdkComponentConfiguration {
    my ($self) = @_;
    my $lcmSdkComponent = $self->getInstalledComponent();
    return undef if ! defined $lcmSdkComponent;

    my $genericCfg = SDB::Install::Configuration::Generic->new();
    $genericCfg->{_ownStepsRegistered} = 1;
    $genericCfg->{_path} = $lcmSdkComponent->{manifestDir};
    $genericCfg->{productKey} = $lcmSdkComponent->getComponentBatchKey();
    return $genericCfg;
}

sub getLCMsdkComponentPersistenceFile {
    my ($self) = @_;
    my $genericCfg = $self->getLCMsdkComponentConfiguration();
    return undef if ! defined $genericCfg;

    return $genericCfg->pers_filename();
}

sub _detectIsUpdateFromLCMsdkPersistenceFile {
    my ($self) = @_;
    return undef if ! $self->hasLCMsdkComponentPersistenceFile();

    my $iniFile = new SDB::Install::IniFile ( $self->getLCMsdkComponentPersistenceFile() );
    my $rc = $iniFile->read ();
    return undef if !$rc;

    my $result = $iniFile->getValue ( undef, '_start_version' );
    $self->{_isUpdate} = defined $result ? 1 : 0;
}

sub hasLCMsdkComponentPersistenceFile {
    my ($self) = @_;
    my $pers_file = $self->getLCMsdkComponentPersistenceFile();
    return undef if ! defined $pers_file;
    return -e $pers_file;
}

sub _shouldIgnorePersistedVersion {
    my ($self, $config) = @_;
    return 1 if $self->hasLCMsdkComponentPersistenceFile() && ! $self->hasPersistenceFile($config);
    return 0 if !$self->hasPersistenceFile($config);

    my $persistency = $self->getPersistenceXMLObject($config);
    return 0 if ! defined $persistency;

    my $persistedComponentVersion = $persistency->getTargetVersionString();
    my $currentComponentVersion = $self->getVersion();
    my $persistedVersion = new SDB::Install::Version(split('\.', $persistedComponentVersion));
    my $currentVersion   = new SDB::Install::Version(split('\.', $currentComponentVersion));
    return $currentVersion->isNewerThan($persistedVersion);
}

sub _detectIsUpdateFromPersistenceXMLObject{
    my $self = shift;
    my $systemComponentManager = $self->getSystemComponentManager();
    if (defined $systemComponentManager){
        my $config = $systemComponentManager->getConfiguration();
        if (defined $config){
            my $persistenceXmlObject = $self->getPersistenceXMLObject($config);
            if (defined $persistenceXmlObject){
                my $action = $persistenceXmlObject->getActionString();
                $self->{_isUpdate} = $action eq 'update' ? 1 : 0;
            }
        }
    }
}
1;
