package LCM::ComponentManager::ComponentScanner;

use SDB::Install::Globals qw ($gProductNameEngine);
use LCM::ComponentManager::MediumComponentManager;
use SDB::Install::Configuration;
use base SDB::Install::Base;
use strict;

our $RETURN_CODE_SUCCESS = 0;
our $RETURN_CODE_ERROR = 1;

sub new {
    my ($class,$componentManager,$instconfig,$isInstall,$isUpdate) = @_;

    my $self = {};
    bless $self, $class;
    $self->{componentManager} = $componentManager;
    $self->{_isInstallConfiguration} = $isInstall;
    $self->{_isUpdateConfiguration} = $isUpdate;
    $self->{instconfig} = $instconfig;
    $self->{_isScanning} = 0;
    return $self;
}

sub scan {
	my ($self, $paramId, $value) = @_;
	$self->resetMsgLstContext();
	my $rc = $RETURN_CODE_SUCCESS;
	
    if ( not defined $value ) {
       $self->appendErrorMessage("Value is empty");
       return $RETURN_CODE_ERROR;
    }
    
    my $msg = $self->getMsgLst ()->addMessage ("Scanning for components...");
    $self->{componentManager}->setMsgLstContext( [$msg->getSubMsgLst(), undef] );
   
    my $isComponentDirs = 0;
    if ($paramId eq 'DvdPath'){
        if(!$self->{componentManager}->detectComponentsByDVDRoot($value)){
            $rc = $RETURN_CODE_ERROR;
        }
        $self->{_isScanning} = 1;
    }
    if ($paramId eq 'ComponentFsRoot'){
        $rc = $self->{componentManager}->detectComponentsByFsRoot($value, $isComponentDirs) ;
        $self->{_isScanning} = 1;
    }
     if ($paramId eq 'DefaultLocation'){
        my @dirs = split( ',', $value );
        $rc = $self->{componentManager}->detectDefaultLocation (\@dirs, $isComponentDirs) ;
        $self->{_isScanning} = 1;
    }
     if ($paramId eq 'ComponentDirs'){
     	$isComponentDirs = 1;
     	my @dirs = split( ',', $value );
        $rc = $self->{componentManager}->detectComponentsByDirectoryList(\@dirs, undef, $isComponentDirs) ;
        $self->{_isScanning} = 1;
    }
    if($rc == $RETURN_CODE_SUCCESS){
        $self->handleActionConfiguration($paramId);
    } elsif ($rc == 4) {
    	$self->appendErrorMessage ("Resident HDBLCM is not able to update $gProductNameEngine!",$self->{componentManager}->getErrMsgLst());
    } else{
        $self->getErrMsgLst()->appendMsgLst($self->{componentManager}->getErrMsgLst());
    }
   
    return $rc;
}

sub printScannedComponents {
    my ($self) = @_;
    if($self->{_isScanning}){
        $self->{componentManager}->printDetectedComponents();
    }
     $self->{_isScanning} = 0;
}

sub handleActionConfiguration{
    my ($self,$paramId) = @_;
    my $isUpdate = $self->{_isUpdateConfiguration};
    my $isInstall = $self->{_isInstallConfiguration};
    if(!$isUpdate&& !$isInstall){
    	return;
    }
    if (($paramId eq 'DvdPath') && ($isUpdate || $isInstall)){
    	$self->{instconfig}->handleSelectionOfServerComponent();
        $self->{instconfig}->handleSelectionOfInternalComponents();
    }
    if ($paramId eq 'ComponentFsRoot' &&  $isInstall){
        $self->{instconfig}->handleSelectionOfServerComponent();
        $self->{instconfig}->handleSelectionOfInternalComponents();
    }
    if ($paramId eq 'ComponentDirs' && $isInstall){
        $self->{instconfig}->handleSelectionOfServerComponent();
        $self->{instconfig}->handleSelectionOfInternalComponents();
    }
}

sub setComponentManager{
	 my ($self,$componentManager) = @_;
	 $self->{componentManager} = $componentManager;
}

return 1;
