package LCM::ComponentWarningsHandler;

use strict;
use LCM::Component;

sub new {
    my ( $class, $component ) = @_;
    my $self = {};
    bless $self, $class;
    $self->{component} = $component;
    $self->{component}->resetWarnings();
    return $self;
}

sub onWarning {
    my ( $self, $message ) = @_;
    $self->{component}->addWarning($message);
}

return 1;
