package LCM::Configuration::Cockpit::CockpitExternalActionConfigurationFactory;

use strict;
use warnings;
use parent qw (LCM::Configuration::AbstractExternalConfigurationFlavourFactory);

use SDB::Install::Globals qw($gProductNameCockpit);
use LCM::Configuration::Cockpit::CockpitStackSystemCollection;
use LCM::Configuration::Cockpit::CockpitStackSelectedSystemValuesBuilder;

sub new{
    my($class,$actionConfig) = @_;
    my $self = bless({},$class);
    $self->{actionConfig} = $actionConfig;
    return $self;
}

sub getProductName{
    return $gProductNameCockpit;
}

sub getValidActions{
    return ['install','update']
}

sub createSystemCollection{
    my $self = shift;
    return LCM::Configuration::Cockpit::CockpitStackSystemCollection->new($self->{actionConfig});
}

sub createSelectedSystemsValuesBuilder{
    my $self = shift;
    return LCM::Configuration::Cockpit::CockpitStackSelectedSystemValuesBuilder->new($self->{actionConfig});
}

1;
