package LCM::Configuration::HdblcmExternalActionConfiguration;

use strict;

use SDB::Install::Configuration::AnyConfig;
use SDB::Install::Configuration qw($bool_true_pattern);
use LCM::ComponentManager::MediumComponentManager;
use LCM::Configuration::ParametersCreator;
use LCM::ComponentManager::ComponentScanner;
use LCM::Utils::CommonUtils qw(findAutoConfiguration);
use LCM::Configuration::ValueChangeListeners::PrepareExecutionEnvironmentListener;
use LCM::Configuration::ValueChangeListeners::ActionConfigurationSelectedSystemListener;
use LCM::Configuration::ValueChangeListeners::ExternalActionConfigComponentsLocationListener;
use LCM::Configuration::ValueChangeListeners::SkipAddComponentsLocationListener;
use LCM::Configuration::ValueChangeListeners::AddComponentsLocationListener;
use LCM::Configuration::GenericStackAny qw($ini_section_general $ini_section_server);
use LCM::MediumAnalyzer;
use LCM::Configuration::AbstractExternalConfigurationFlavourFactory;
use LCM::ComponentManager::PrintDetectedComponentsOutputHandler;

use parent qw (LCM::Configuration::ActionConfiguration Exporter);

sub new {
    my ( $class, $options, $configfile, $batchMode ) = @_;

    if(!defined($configfile)) {
        $configfile = LCM::Utils::CommonUtils::findAutoConfiguration();
    }

    my $self  = $class->SUPER::new( $options, $configfile );
    my $order = 0;

    $self->{params} = {
        'BootstrapFromResident'    => LCM::Configuration::ParametersCreator::GetParamBootstrapFromResident($order++, $ini_section_general),
        'UseSimpleUI' => GetParamUseSimpleUI($order++, $ini_section_general),
        'DvdPath' => GetParamDvdPath($order++, $ini_section_general),
        'DefaultLocation' => $self->getParamDefaultLocation($order++, $ini_section_general),
        'ComponentDirs' => GetParamComponentDirs($order++, $ini_section_general),
        'AddComponentsLocation' => GetParamAddComponentsLocation($order++, $ini_section_general),
        'ComponentFsRoot' => GetParamComponentFsRoot($order++, $ini_section_general),
        'Action' => LCM::Configuration::ActionConfiguration::getParamAction( $order++ ),
        'SkipHostagentCalls' => $self->getParamSkipHostagentCalls($order++, $ini_section_general),
        'UseHttp'         => $self->getParamUseHttp        ($order++, $ini_section_general),
    };
    $self->{params}->{'Action'}->{set_interactive} = 0;

    my $action_sid = SDB::Install::Configuration::AnyConfig::getParamSID( $self, $order++, undef );
    $action_sid->{'excludeFromConfigDump'} = 1;
    $action_sid->{'set_interactive'}       = 0;
    $action_sid->{'hidden'}                = 1;
    #fix read from config file
    $action_sid->{'section'}                = $ini_section_server;
    $self->{params}->{'Action_SID'} = $action_sid;
    $self->{params}->{'RemoteExecution'} = $self->getParamRemoteExecution($order++, $ini_section_general, 0);
    if ( !$batchMode ) {
        $self->{params}->{'SelectedSystem'} = $self->getParamSelectedSystem( $order++, undef );
    }

    $self->setHidden('UseSimpleUI', 1);
    $self->addListeners();
    return $self;
}

sub setActionBatchValue {
    my ($self, ) = @_;
    $self->{params}->{'Action'}->{batchValue} = 'install';
}

sub getAction {
    my ($self, $batchMode) = @_;

    my $action = $self->SUPER::getAction();

    if (!$batchMode && $action eq 'update')  {
        my $sid = $self->getValue('Action_SID');
        if ( not defined $sid ) {
            return undef;
        }
    }
   return $action;
}

sub getSID {
    return $_[0]->getValue('Action_SID')
}

sub isSimpleMode {
    my ($self) = @_;
    return !$self->isSkipped('UseSimpleUI') && $self->getBatchValue('UseSimpleUI') =~ /$bool_true_pattern/;
}

sub getParamSelectedSystem {
    my ( $self, $order, $section ) = @_;
    my $param = LCM::Configuration::ParametersCreator::GetParamSelectedSystem( $order, $section );

    $param->{'f_init_interactive_values'} = sub {
            my $valuesBuilder = $self->createSelectedSystemsValuesBuilder();
            $valuesBuilder->initDefaultSystems();
            $param->{'ui_values'}        = $valuesBuilder->getUiValues();
            $param->{'valid_values'}     = $valuesBuilder->getValidValues();
        };
    return $param;
}

sub CheckParams{
    my($self,$batchMode) = @_;
    $self->analyzeMedium();
    return $self->SUPER::CheckParams($batchMode);
}

sub analyzeMedium {
    my ($self, ) = @_;
    my $analyzer = new LCM::MediumAnalyzer($self);
    return $analyzer->analyze();
}

sub checkDvdPath {
    my ( $self, $dvdPath ) = @_;
    return $self->checkComponentSourcesCompatibility();
}

sub checkComponentFsRoot {
    my ( $self, $componentFsRoot ) = @_;
    return $self->checkComponentSourcesCompatibility();
}

sub checkComponentSourcesCompatibility {
    my ( $self, $componentFsRoot ) = @_;
    if ( $self->getValue('ComponentFsRoot') and $self->getValue('DvdPath') ) {
        $self->appendErrorMessage("Simultaneous use of component_medium and component_root is forbidden");
        return 0;
    }
    return 1;
}

sub getComponentManager {
    my ($self) = @_;
    if ( not defined $self->{componentManager} ) {
        $self->setComponentManager(new LCM::ComponentManager::MediumComponentManager($self));
    }
    return $self->{componentManager};
}


sub setComponentManager {
    my ($self, $componentManager) = @_;
    $self->{componentManager} = $componentManager;
    $self->getScanner()->setComponentManager($self->{componentManager});
}

sub addListeners(){
    my ($self) = @_;
    $self->addParameterListener( 'SelectedSystem', LCM::Configuration::ValueChangeListeners::ActionConfigurationSelectedSystemListener->new());
    $self->addParameterListener( 'ComponentDirs', LCM::Configuration::ValueChangeListeners::SkipAddComponentsLocationListener->new());
    $self->addParameterListener( 'ComponentDirs', LCM::Configuration::ValueChangeListeners::ExternalActionConfigComponentsLocationListener->new($self->getScanner(), 'ComponentDirs'));
    $self->addParameterListener( 'DvdPath', LCM::Configuration::ValueChangeListeners::SkipAddComponentsLocationListener->new());
    $self->addParameterListener( 'DvdPath', LCM::Configuration::ValueChangeListeners::ExternalActionConfigComponentsLocationListener->new($self->getScanner(),'DvdPath'));
    $self->addParameterListener( 'AddComponentsLocation', LCM::Configuration::ValueChangeListeners::AddComponentsLocationListener->new());
    $self->addParameterListener( 'ComponentFsRoot', LCM::Configuration::ValueChangeListeners::SkipAddComponentsLocationListener->new());
    $self->addParameterListener( 'ComponentFsRoot', LCM::Configuration::ValueChangeListeners::ExternalActionConfigComponentsLocationListener->new($self->getScanner(),'ComponentFsRoot'));
    $self->addParameterListener( 'DefaultLocation', LCM::Configuration::ValueChangeListeners::ExternalActionConfigComponentsLocationListener->new($self->getScanner(),'DefaultLocation'));
    $self->addParameterListener( 'Action_SID', LCM::Configuration::ValueChangeListeners::PrepareExecutionEnvironmentListener->new());
}

sub getScanner{
    my $self = shift;
    $self->{scanner} = $self->{scanner} // LCM::ComponentManager::ComponentScanner->new($self->getComponentManager(),$self,0,0);
    return $self->{scanner};
}

sub getParamSkipHostagentCalls;
* getParamSkipHostagentCalls =
        \&SDB::Install::Configuration::AnyConfig::getParamSkipHostagentCalls;

sub getParamRemoteExecution;
* getParamRemoteExecution =
        \&SDB::Install::Configuration::AnyConfig::getParamRemoteExecution;

sub getParamUseHttp;
* getParamUseHttp =
        \&SDB::Install::Configuration::AnyConfig::getParamUseHttp;

# Override
sub isPendingInstallation {
    my ($self) = @_;
    if ($self->SUPER::isPendingInstallation()) {
        return 1;
    }
    my @pendingInstallations = $self->getSystemCollection()->getPendingInstallations();
    my $sid = $self->getSID();
    my $isPendingInstallation = grep { $sid eq $_ } @pendingInstallations;
    return $self->getAction() eq 'install' && $isPendingInstallation;
}

sub getSystemCollection{
    my $self = shift;
    if(!defined $self->{_systemsCollection}){
        $self->{_systemsCollection} = $self->createSystemCollection();
    }
    return $self->{_systemsCollection};
}

sub printActionHeaderMessage{
    my($self, $msgList) = @_;
    if (!$self->isSimpleMode()){
        $self->getComponentManager()->addComponentsOutputHandler(LCM::ComponentManager::PrintDetectedComponentsOutputHandler->new());
        $self->getScanner()->printScannedComponents();
    }
}

sub createFlavouredConfigurationFactory{
    my $self = shift;
    $self->{flavouredConfigFactory} = LCM::Configuration::AbstractExternalConfigurationFlavourFactory::create($self);
}

sub getFlavouredConfigurationFactory{
    my $self = shift;
    if(! defined $self->{flavouredConfigFactory}){
        $self->createFlavouredConfigurationFactory();
    }
    return $self->{flavouredConfigFactory};
}

sub getProductName{
    my $self = shift;
    return $self->getFlavouredConfigurationFactory()->getProductName();
}

sub getValidActions{
    my $self = shift;
    return $self->getFlavouredConfigurationFactory()->getValidActions();
}

sub createSystemCollection{
    my $self = shift;
    return $self->getFlavouredConfigurationFactory()->createSystemCollection();
}

sub createSelectedSystemsValuesBuilder{
    my $self = shift;
    return $self->getFlavouredConfigurationFactory()->createSelectedSystemsValuesBuilder();
}

sub getFlavour{
    my $self = shift;
    return $self->getComponentManager()->getHANAFlavour();
}

sub setValidActions {
    my $self = shift;
    $self->{params}->{'Action'}->{'valid_values'} = $self->getValidActions();
}

sub getParamDefaultLocation {
    my ($self, $order, $section) = @_;
    return {
        'order'                  => $order,
        'opt_arg'                => '<path1>[,<path2>]...',
        'type'                   => 'string',
        'section'                => $section,
        'value'                  => undef,
        'default'                => undef,
        'set_interactive'        => 0,
        'str'                    => 'Comma separated list of component directories',
        'desc'                   => 'Default detected components',
        'hidden'                 => 1,
        'leaveEmptyInConfigDump' => 1,
        'mandatory'              => 0
    };
}

1;
