package LCM::Configuration::Hosts::RemoveHosts::Web::RemoveHostsConfiguration;

use strict;
use base qw (LCM::Configuration::Hosts::RemoveHosts::RemoveHostsConfiguration);

sub InitDefaults {
	my ( $self, $kit ) = @_;
	$self->SUPER::InitDefaults($kit);
	$self->_convertParameterRemoveHostsToCsv();
	return 1;
}

sub checkRemoveHosts {
	my ($self, $value)  = @_;
	
	if(!defined($value) || length($value) == 0){
		$self->PushError("There must be at least one host to proceed");
		return undef;
	}
	return $self->SUPER::checkRemoveHosts($value);
}

# Parameter RemoveHosts is converted to CSV, because this would generically expose it via the
# SLP, showing all valid hosts for removal
sub _convertParameterRemoveHostsToCsv {
	my ($self) = @_;
	my $removeHostsParameter = $self->{params}->{RemoveHosts};
	$removeHostsParameter->{type} = 'csv';
	my $instance = $self->getOwnInstance();
	$removeHostsParameter->{valid_values} = $instance->get_hosts();
	$removeHostsParameter->{ui_values} = [map { "Roles: " . $self->_getHostRoles($_) } @{$instance->get_hosts()}];
}

sub _getHostRoles {
	my ($self, $host) = @_;
	my $detector = $self->getRemoveHostsDetector();
	my $hostRoles = $detector->getHostRoles($host);

	return join(',', @{$hostRoles});
}

1;
