package LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationInRename;

use strict;
use base qw ( LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration);
use LCM::Configuration::GenericStackAny qw ( $ini_section_general  );
use SDB::Install::Globals qw ($gProductNameSystem);
use SDB::Install::SAPSystem qw(CollectSAPSystems);

sub new {
    my $self = shift->SUPER::new (@_);
    return $self;    
}

sub getUpdateHostParameters{
    my($self,$order) = @_;
    my $params = $self->SUPER::getUpdateHostParameters($order);
    $params->{'HostagentPassword'}  = $self->getParamHostagentPassword ($order++, $ini_section_general);
    return $params;
}

#----------------------------------------------------------------------------
#
# After sysytem rename own instance points to old sid/instance.
# Explicitly use instance linked to the new sid.
#
sub getOwnInstanceAfterRename {
    my $self    = shift();
    my $error   = "Failed to detect own instance after $gProductNameSystem rename.";
    my $system = $self->_getRefreshedSystem();
    return undef unless $system;

    if (!$system->hasNewDB()) {
        $self->PushError ( $error );
        return undef;
    }

    my $instance = $system->getNewDBInstances ()->[0];
    unless ( $instance ) {
        $self->PushError ( $error );
        return undef;
    }
    return $instance;
}

sub _getRefreshedSystem {
    my $self    = shift();
    my $systems = CollectSAPSystems ( undef, 1 );
    my $error   = "Failed to detect own instance after $gProductNameSystem rename.";

    unless ( $systems ) {
        $self->PushError ( $error );
        return undef;
    }

    my $system = $systems->{ $self->getValue ( 'SID' ) };
    unless ( $system ) {
        $self->PushError ( $error );
        return undef;
    }
    return $system;   
}

#Override
sub getCurrentSAPSystem {
    return $_[0]->_getRefreshedSystem();
}

return 1;