package LCM::Configuration::NewDBUser::NewDBUser;

use SDB::Install::SysVars qw ($isWin);
use LCM::Configuration::NewDBUser::User;
use SDB::Install::NewDBUser;
use SDB::Common::Utils qw(createSysAdminUserName);

use strict;

our @ISA = qw (SDB::Install::NewDBUser);

sub new {
	my $self = shift->SUPER::new(@_);
	my $domain = $isWin ? $self->{domain} : undef;
	my $userName = createSysAdminUserName($self->{sid}, $domain);

	$self->{admuser} = new LCM::Configuration::NewDBUser::User($userName);
	return $self;
}

1;
