package LCM::Configuration::NewDBUser::User;

use SDB::Install::NewDBUser;
use SDB::Install::Globals qw ($gOperationCollectHostInfo);
use SDB::Install::System;
use SDB::Install::SysVars qw ($isWin);

use strict;

our @ISA = qw (SDB::Install::User);

sub new {
	my $self = shift->SUPER::new(@_);

	$self->setVerifyOnSystemHosts(1);
	$self->setVerifyOnAdditionalHosts(1);

	return $self;
}

sub setVerifyOnSystemHosts {
	$_[0]->{_verifyOnSystemHosts} = $_[1];
}

sub setVerifyOnAdditionalHosts {
	$_[0]->{_verifyOnAdditionalHosts} = $_[1];
}

sub getVerifyOnSystemHosts {
	return $_[0]->{_verifyOnSystemHosts};
}

sub getVerifyOnAdditionalHosts {
	return $_[0]->{_verifyOnAdditionalHosts};
}

sub verifyPasswordUx {
	my ($self, $passwd, $instconfig) = @_;

	if (SDB::Install::System::isSidadmin($instconfig->getSID())) {
		return $self->verifyPasswordSHA($passwd, $instconfig);
	}
	return $self->SUPER::verifyPasswordUx($passwd);
}

sub verifyPasswordSHA {
	my ($self, $passwd, $instconfig) = @_;

	require SDB::Install::RemoteHostctrlHosts;

    my $msg = $instconfig->getMsgLst ()->addMessage ("Verifying $self->{name} password...");
	my $verificationHostnames = $self->_getVerificationHostnames($instconfig);

	if (!defined $instconfig->getSAPSystem()) {
        $instconfig->appendErrorMessage("No SAP System found");
        return undef;
    }

	my $nr = $instconfig->getSAPSystem()->getNewDBInstanceNr();
	my $rc = 1;
	my $username = $self->{name};
	my $useHttps = $instconfig->isUseHttps();

	require SDB::Install::SAPControl;

    foreach my $host(@{$verificationHostnames}){
        my $sapcontrol = new SDB::Install::SAPControl ($host,
                                                       $nr,
                                                       $username,
                                                       $passwd,
                                                       $useHttps);
        if(!$sapcontrol->isServiceRunning()){
            $instconfig->addWarning("Unable to verify '$self->{name}' password on host '$host' because the service sapstartsrv is not running.");
            next;
        }
    	$sapcontrol->accessCheck ();
    	if ($sapcontrol->ErrorState()) {
    		my $error = $sapcontrol->GetErrorString();
    		my $errMsg = "Password verification failed on host '$host' : ";

    		if ($error =~ '^.*Invalid\sCredentials.*') {
    		  $instconfig->setErrorMessage($errMsg . "Unknown user password combination");
    		} else {
    		  $instconfig->setErrorMessage($errMsg . $sapcontrol->GetErrorString());
    		}

    		return 0;
    	}
    }
    return 1;
}

sub _getVerificationHostnames {
	my ($self, $instconfig) = @_;

	my $shouldVerifyOnSystemHosts =  $self->getVerifyOnSystemHosts();
	my $shouldVerifyOnAdditionalHosts =  $self->getVerifyOnAdditionalHosts();
	my $verificationHostnames = $shouldVerifyOnSystemHosts ? $instconfig->getSystemHosts() : [];
	my $additionalRemoteHostsObject = $instconfig->getAdditionalRemoteHosts();

	if (defined($additionalRemoteHostsObject) && $shouldVerifyOnAdditionalHosts) {
		push(@{$verificationHostnames}, @{$additionalRemoteHostsObject->getHostNames()});
	}

	return $verificationHostnames;
}

1;
