package LCM::Configuration::PrintComponentListConfiguration;
use parent qw(LCM::Configuration::GenericStackAny SDB::Install::Configuration::AnyConfig);
use strict;
use warnings;

use LCM::Installer;
use SDB::Install::Globals qw($gProductNameEngine);
use LCM::Configuration::GenericStackAny;

sub new{
    my $self = shift->SUPER::new (@_);
    
    my $order = 0;
    
    $self->{params} = {
        'Format'           => $self->getParamFormat($order++, $ini_section_general),
    };

	if (!$self->initialize()) {
		return undef;
	}
	
    return $self;
}

sub getParamFormat {
    my ($self, $order, $section) = @_;
    return {
        opt          => 'format',
        short_opt    => 'f',
        str          => 'Specifies output format for the component list',
        type         => 'string',
        valid_values => ['table', 'xml'],
        default      => 'xml',
        order        => $order,
        value        => undef,
        init_with_default => 1,
        set_interactive   => 0,
    }
}

sub initialize {
	my $self = shift;
	my $installer = new LCM::Installer();
	$installer->setMsgLstContext([$self->getMsgLst()]);
	my $scm = $installer->getOwnSystemComponentManager();
	$self->{systemComponentManager} = $scm;
	if (!defined $scm){
		$self->setErrorMessage("Cannot determine the installed '$gProductNameEngine'. Start the tool from its original location inside the database.");
		return undef;
	}
	
	return 1;
}

sub getSID {
	return $_[0]->{systemComponentManager}->getSid();
}

sub getSystemComponentManager {
	return $_[0]->{systemComponentManager};
}

sub getProductName{
    my $flavourProductName = $_[0]->getFlavourProductName();
    return $flavourProductName. " Components";
}

sub getAction{
	return 'print_component_list';
}

1;
