package LCM::Configuration::Validators::FileModeValidator;

use strict;

use parent 'LCM::Configuration::Validators::Validator';
use LCM::FileUtils qw (GetPermissions);

sub isValid {
	my ($self, $path, $uid, $gid, $mode, $errorMessageList) = @_;

	return 1 if(!-e $path);

	my @statbuf = stat($path);
	my $ocatlMode = oct($mode);
	my $permissions = GetPermissions($path);
	my $ocatlPermissions = oct($permissions);

	if ($statbuf[4] != $uid){
		return $self->_handleError($path, 'uid', $uid, $statbuf[4], $errorMessageList);
	}
	if ($statbuf[5] != $gid) {
		return $self->_handleError($path, 'gid', $gid, $statbuf[5], $errorMessageList);
	}
	if (($ocatlPermissions & $ocatlMode) != $ocatlMode){ # Do not break if permissions are looser than expected
		return $self->_handleError($path, 'mode', $mode, $permissions, $errorMessageList);
	}
	return 1;
}

sub _handleError {
	my ($self, $path, $accessor, $expectedId, $foundId, $errorMessageList) = @_;
	my $message = sprintf("Wrong %s on file %s. Expected %s but found %s", $accessor, $path, $expectedId, $foundId);
	$errorMessageList->addError($message);
	print "$message\n";
	return 0;
}

1;
