package LCM::Configuration::ValueChangeListeners::CheckInstallation::RemoteExecutionListener;

sub new {
	return bless({}, shift());
}

sub onValueChange {
    my ( $self, $value, $instconfig ) = @_;

    my $isDistributedSystem = $instconfig->isDistributedSystem();
    my $isSkipRootCredentials = ($value eq 'saphostagent') || !$isDistributedSystem;
    my $isSkipSHAPassword = (!$isDistributedSystem || $value ne 'saphostagent');

    $instconfig->setSkip('RootUser', $isSkipRootCredentials ? 1 : 0);
    $instconfig->setSkip('RootPassword', 1); # root password will be unskipped in AnyConfig's sub tryRemoteKeyAuthorization if needed

    return 1;
}

1;
