package LCM::Configuration::ValueChangeListeners::Cockpit::CockpitParamsListener;

use strict;
use SDB::Install::Globals qw($gProductNameCockpit
                             $gProductNameEngine
                             $gKeynameXS2
                             $gKeynameCockpitStack);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $sid, $configuration) = @_;

# The current listener is added only in the 'CockpitStackUpdateConfiguration', which is always created if the target
# server (the one from the installation kit) has the Cockpit flavour. Unskipping the 'CockpitXSSpace' parameter will trigger
# all the new parameters, which are only relevant for the scenario when we are installing Cockpit on 
# HANA Platform edition. If the 'CockpitXSSpace' parameter remains skipped, this configuration will behave exactly the same as 
# 'GenricStackUpdateConfiguration'
    if (!$configuration->isCockpitStackDetected()) {
# We cant continue with this scenario if no cockpit stack component is detected
        $configuration->setErrorMessage("No $gProductNameCockpit component was detected.");
        $configuration->setNoRetry('SID', 1);
        return 0;
    }

    if (!$self->_checkDBMode($configuration)) {
        my $errorMessage = "$gProductNameCockpit Stack requires that the underlying $gProductNameEngine is configured in multi-tenant database containers.".
                           "The system '$sid' currently does not meet this requirement";
        $configuration->setErrorMessage($errorMessage);
        $configuration->setNoRetry('SID', 1);
        return 0;
    }

# Unskip the SYSTEMDB credentials as it may turn out that a tenant DB should be created
    if (!$configuration->isCockpitStackUpdate()) {
        $configuration->setSkip('SystemUser', 0);
        $configuration->setSkip('SQLSysPasswd', 0);
    }

    $configuration->setInteractive('AutoAddXS2Roles', 0);
    $configuration->setSkip('CockpitXSSpace', 0);
    return 1;
}

sub _checkDBMode {
    my ($self, $configuration) = @_;
    my $instance = $configuration->getOwnInstance();
    if (defined($instance) && !$instance->isMultiDb()) {
        return 0;
    }
    return 1;
}

1;