package LCM::Configuration::ValueChangeListeners::Cockpit::Uninstall::CockpitStackListener;

use strict;
use SDB::Install::Globals qw($gKeynameCockpitStack $gKeynameXS2);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, undef, $configuration) = @_;
    my $scm = $configuration->getSystemComponentManager();
    my $isServerSelected = $scm->isHDBServerComponentSelected();
    my $isCockpitSelected = $scm->isComponentSelected($gKeynameCockpitStack);
    my $isCockpitOnPlatform = $configuration->isCockpitOnPlatformAction();
    my $isXS2Selected = $scm->isComponentSelected($gKeynameXS2);
    my $isUninstallingCockpit = $isCockpitSelected && !$isServerSelected && $isCockpitOnPlatform; # We dont need the KeepTenant parameter if the server will be uninstalled
    my $isXSSpaceNeeded = $isUninstallingCockpit && !$isXS2Selected; # If we uninstall XSA, we dont need the space

    $configuration->setSkip('CockpitXSSpace', !$isXSSpaceNeeded);
    $configuration->setSkip('KeepCockpitTenant', !$isUninstallingCockpit);
    $configuration->setSkip('CockpitTenant', !$isUninstallingCockpit);

    if ($isUninstallingCockpit) {
        $self->_detectCockpitTenant($configuration);
    }

    if($isXSSpaceNeeded){
        $self->_updateOrgNameValue($configuration);
        $configuration->setHidden('OrgName',1);
        $configuration->setInteractive('OrgName',0);
    }

    return 1;
}

sub _detectCockpitTenant {
    my ($self, $configuration) = @_;
    my $sapSys = $configuration->getSAPSystem();
    my $userConfiguration = $sapSys ? $sapSys->getUserConfig() // {} : {};
    my $tenantName = $userConfiguration->{cockpit_tenant_db};
    if ($tenantName) {
        $configuration->setDefault('CockpitTenant', $tenantName, 1);
        $configuration->setInteractive('CockpitTenant', 0);
    }
}

sub _updateOrgNameValue {
    my ($self, $configuration) = @_;
    return 1 if(defined $configuration->getValueOrBatchValue('OrgName'));

    my $adminLoginValue = $configuration->retrieveXsAdminLoginParam('org-name');
    if ($adminLoginValue) {
        $configuration->setDefault('OrgName', $adminLoginValue, 1);
    }
    return 1;
}

1;