package LCM::Configuration::ValueChangeListeners::Cockpit::Uninstall::KeepCockpitTenantListener;

use strict;
use parent 'LCM::Configuration::ValueChangeListeners::Uninstall::RecomputeCredentialsListener';

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
# We need the SYSTEMDB credentials and the tenant DB name, so we can delete it via SQL
    my $shallSkipDBCredentials = !$value || $self->_areDBCredentialsNeeded($configuration) ? 0 : 1;

    $configuration->setSkip('SystemUser', $shallSkipDBCredentials);
    $configuration->setSkip('SQLSysPasswd', $shallSkipDBCredentials);

    return 1;
}

1;